#!/bin/bash

num_replicas=30
num_neighbors=10

i0=0
i1=6

jobs=""
for i in `seq $i0 $i1`
do
    jobs="$jobs job$i.log"
done

cat $jobs | grep EXCHANGE_ACCEPT | awk -v N=$num_replicas -v M=$num_neighbors '{
    a[$2,$3-$2]++
    if (NR==1) { t0=$5; print "#first run:",t0 }
    t=$5
}END{
    print "#last run:",t
    for(i=0;i<N-1;i++) {
	printf "%d",i
	for(n=1;n<=M/2;n++) {
	    printf " %f",a[i,n]*10/(t-t0+1)
	    A[n]+=a[i,n]*10/(t-t0+1)
	}
	printf "\n"
    }
    printf "#avr"
    for(n=1;n<=M/2;n++) printf " %f",A[n]/(N-1)
    printf "\n"
}'
