use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $modules = {};  my $manpage = {};
foreach my $module ( qw( Admins Hardware Installed Machine 
			 Maintenance Obsolete ) ) {
  my $module = "TCB::System::$module";
  my $file = $module;
     $file =~ s/::/\//g;  
     $file =~ s/$/.pm/;
  my $shortfile = $file;  $shortfile =~ s%^TCB/System/%%;
  my $libdir = join('/', '$(INST_LIBDIR)', $shortfile);
  my $man3 = join('/', '$(INST_MAN3DIR)', "$module.3");
  $$modules{$file} = $libdir; $$manpage{$file} = $man3;
}

my @progs;
foreach ( qw( htaccess-base htgroup-base htpasswd-base stylesheet.css
	system/obsolete.cgi system/obsolete_admin.cgi ) ) {
  push @progs, "cgi-bin/$_";
}
my $progs = [ @progs ] ;

WriteMakefile(
    'NAME'	=> 'TCB::System::Obsolete',
    'DISTNAME'  => 'TCB-System-Obsolete',
    'MAN3PODS'  => $manpage, 
    'VERSION_FROM' => 'Version.pm', # finds $VERSION
    'PREREQ_PM' => { 'DBIx::Frame' => 1.05, 'TCB::System' => 0.99 },
    'PM' 	=> $modules,
    'EXE_FILES' => $progs,
    'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
    'AUTHOR'    => 'tskirvin@ks.uiuc.edu (Tim Skirvin)',
    'ABSTRACT_FROM'  => 'TCB/System/Obsolete.pm',
);
