$VERSION = "1.00";
package TCB::System::Admins;
our $VERSION = "1.00";

# -*- Perl -*- 		Thu May 13 13:19:53 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################

=head1 NAME 

TCB::System::Admins - TCB Group Sysadmin Listings Database

=head1 SYNOPSIS

  use TCB::System::Admins;

See B<TCB::System::Obsolete> or B<TCB::System> for more information on how
to use this module.

=head1 DESCRIPTION

The 'Admins' table lists all TCB sysadmins and their contact information.

This table contains the following fields:

 Internal Information
  ID		Unique numeric ID - auto-generated (INT)

 Basic Information (TINYTEXT fields, unless noted)
  Name          Full name of the administrator
  ShortName     Short name of the administrator (ie their login) 
  Email         Email address of the administrator
  Office        Office address of the administrator
  Notes         Notes about the administrator (TEXT)

Key fields: 	ShortName

List items: 	ShortName, Name, Email, Office

Required: 	Same as Key fields.

Default order: 	ShortName

Admin Fields:	None

The 'Installed' table depends on this table directly.

Depends on the 'Room' table.

=cut

###############################################################################
### Initialization ############################################################
###############################################################################
use vars qw( @ISA $FIELDS $KEYS $NAME $LIST $BIBFILE $ABSTRACTS $REQUIRED 
	     $ADMIN $ORDER $WEBROOT );
use strict;
use warnings;
use CGI;
use TCB::System;

push @ISA, qw( TCB::System );

###############################################################################
### Database Variables ########################################################
###############################################################################
$NAME = "Admins";
$FIELDS = {
  'ID'            =>  'INT NOT NULL PRIMARY KEY AUTO_INCREMENT',
  'ShortName'     =>  'TINYTEXT',   'Name'   => 'TINYTEXT',
  'Email'         =>  'TINYTEXT',   'Office' => 'TINYTEXT',
  'Notes'         =>  'TEXT'
         };
$KEYS  = [ 'ShortName' ];
$LIST  = [ 'ShortName', 'Name', 'Email', 'Office' ];
$REQUIRED = $KEYS;
$ADMIN = [ ];
$ORDER = [ 'ShortName' ];

###############################################################################
##### Functions ###############################################################
###############################################################################

=head2 Internal Functions 

=over 4

=item html ( ENTRY, TYPE, OPTIONS )

Prints the HTML version of the table.  Heavily customized for the TCB
environment, but then again so is the whole program.                            

=cut

sub html {
  my ($self, $entry, $type, $options, @rest) = @_;
  my $cgi = new CGI; 	$entry ||= {};

  my @list;
  foreach ( $self->select('Room', {}, undef )) {
    push @list, join(" ", $self->make_list('Room', $_));
  }

  # my @list;
  # my %hash = $self->select_list_id('Room');
  # foreach (sort keys %hash) { 
  #   next unless ref $hash{$_};
  #   push @list, join(" ", @{$hash{$_}});
  # }

  if (lc $type eq 'search') { unshift(@list, '') } 
  
  my @return = <<HTML;

<div class="basetable">
 <div class="row2">
  <span class="label">Short Name</span>
  <span class="formw"> 
     @{[ $cgi->textfield('ShortName', $$entry{ShortName} || "", 10, 255) ]}
  </span>
  <span class="label">Name</span>
  <span class="formw"> 
     @{[ $cgi->textfield('Name', $$entry{Name} || "", 30, 255) ]}
  </span>
 </div>

 <div class="row2">
  <span class="label">Email</span>
  <span class="formw"> 
     @{[ $cgi->textfield('Email', $$entry{Email} || "", 30, 255) ]}
  </span>
  <span class="label">Office</span>
  <span class="formw"> 
     @{[ $cgi->popup_menu('Office', \@list, $$entry{Office} || "") ]}
  </span>
 </div>

 <div class="row1">
  <span class="label">Notes</span>
  <span class="formw">
      @{[ $cgi->textarea(-name=>'Notes', -default=>$$entry{Notes} || "",
                        -rows=>5, -cols=>70, -maxlength=>65535,
                        -wrap=>'physical') ]}
  </span>
 </div>

 <div class="submitbar"> @{[ $cgi->submit(-name=>"Submit") ]} </div>
</div>
HTML
  wantarray ? @return : join("\n", @return);
}

=back

There is no text() field at present.

=cut

###############################################################################
##### main() ##################################################################
###############################################################################

TCB::System->table_add($NAME, $FIELDS, $KEYS, $LIST, $ORDER, $ADMIN, 
			$REQUIRED, \&html, \&text);

=head1 NOTES

Most of the functionality of this table has later been replaced by LDAP;
but it still may be handy to someone.

The tables themselves were designed by the author, Tim Skirvin.

=head1 TODO

Making a nice user interface, rather than just an administrative
interface, would be helpful.

=head1 REQUIREMENTS

Perl 5.6.1 or greater, DBIx::Frame, TCB::System

=head1 SEE ALSO

B<TCB::System::Obsolete>, B<TCB::System>, B<DBIx::Frame>

=head1 AUTHOR

Tim Skirvin <tskirvin@ks.uiuc.edu>

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-system-obsolete>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-system-obsolete/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.2  	Tue Apr  2 15:35:25 CST 2002
### First version fully using DBI::Frame and commented.
# v1.00         Thu May 13 13:19:53 CDT 2004
### Ready to be a part of DBIx::Frame.
