use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $modules = { 
  'TCB/Seminar.pm' => '$(INST_LIBDIR)/Seminar.pm',
  'TCB/Seminar/CheckList.pm' => '$(INST_LIBDIR)/Seminar/CheckList.pm',
  'TCB/Seminar/Functions.pm' => '$(INST_LIBDIR)/Seminar/Functions.pm',
  'TCB/Seminar/Lecture.pm' => '$(INST_LIBDIR)/Seminar/Lecture.pm' 
};

my $man3    = { 
  'TCB/Seminar.pm' => '$(INST_MAN3DIR)/TCB::Seminar.3',
  'TCB/Seminar/CheckList.pm' => '$(INST_MAN3DIR)/TCB::Seminar::CheckList.3',
  'TCB/Seminar/Functions.pm' => '$(INST_MAN3DIR)/TCB::Seminar::Functions.3',
  'TCB/Seminar/Lecture.pm' => '$(INST_MAN3DIR)/TCB::Seminar::Lecture.3' 
};

WriteMakefile(
    'NAME'      => 'TCB::Seminar',
    'DISTNAME'  => 'TCB-Seminar',
    'MAN3PODS'  => $man3,
    'VERSION_FROM' => 'Version.pm', # finds $VERSION
    'PREREQ_PM'    => { 'DBIx::Frame' => '1.05', 'CGI::SHTML' => 1.27 },
    'PM' 	=> $modules,
    'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
    'AUTHOR'    => 'tskirvin@ks.uiuc.edu (Tim Skirvin)',
    'ABSTRACT_FROM'  => 'TCB/Seminar.pm',
);
