$VERSION = "0.95";
package TCB::Seminar;
our $VERSION = "0.95";

# -*- Perl -*- 		Fri May 21 09:13:04 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.  All rights reserved.
# Distribution terms are below. Copyright 2002-2004, Tim Skirvin and UIUC 
# Board of Trustees.
###############################################################################

=head1 NAME

TCB::Seminar - the TCB Seminar Database

=head1 SYNOPSIS

  use TCB::Seminar;
  my $DB = TCB::Seminar->connect( $DATABASE, $DBUSER, $DBPASS, 
                                             $DBHOST, $DBTYPE )
        or die("Couldn't connect to $DBHOST: $DBI::errstr\n");

See below for how to actually use this object.

=head1 DESCRIPTION

TCB::Seminar is a DBIx::Frame object used to track seminars within the
Theoretical and Computational Biophysics Group at UIUC.  It is meant to
hold both the list of seminars that the Group has held (public
information) and any information necessary to ensure that the seminars go
off as planned (private information).  It consists of a series of public
CGI scripts that load this information from a central database, several
more scripts that are used internally to track the information, and some
perl modules that tie it all together.

This base class is used to load the table definitions and basic functions
for the database.  

Specific tables offered by this class:

=over 4

=item TCB::Seminar::Lecture - individual seminars

=item TCB::Seminar::CheckList - checklist of pre-seminar information

=back

See each table's documentation for more information.

Additional functions are offered in B<TCB::Seminar::Functions>.

=cut

use strict;
use vars qw(@ISA @PROBS @MODULES $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG );
use warnings;

###############################################################################
### User Variables ############################################################
###############################################################################
@MODULES  = qw( DBIx::Frame Exporter TCB::Seminar::Functions 
	        TCB::Seminar::CheckList TCB::Seminar::Lecture );
@ISA      = qw( DBIx::Frame Exporter );
$SERVER   = "db.ks.uiuc.edu";	     		     # Default web server 
$DATABASE = "seminar";	     
$DBTYPE	  = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;

###############################################################################
### main() ####################################################################
###############################################################################
foreach ( @MODULES ) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if scalar @PROBS;

# Initialize DBIx::Frame (this has already been done a few times, but this
# allows us to have a definite known state to finish with)
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);
###############################################################################

1;

=head1 NOTES

These tables were designed by Tim Skirvin <tskirvin@ks.uiuc.edu> in 2002.
The Lecture table is far more regularly used than the CheckList table, but
both have performed their duties quite well.

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>.

=head1 SEE ALSO

B<DBIx::Frame>, B<TCB::Seminar::Functions>, B<TCB::Seminar::CheckList>, 
B<TCB::Seminar::Lecture>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-seminar/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-seminar/license.html>
for details.

=head1 COPYRIGHT

Copyright 2002-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.1 	Mon Jun  3 09:23:54 CDT 2002
### Basic code to load up other modules as necessary.  Documentation not
### finished.  Based on first specification, which is probably not what
### we'll actually use, but I need a draft.
# v0.2  Mon Jun 17 15:33:07 CDT 2002
### Commented and actually getting ready for deployment.  
# v0.9  Wed Aug 14 15:02:27 CDT 2002
### Getting ready for publishing.  Documentation complete.
# v0.95	Fri May 21 09:19:45 CDT 2004 
### Updating for DBIx::Frame, and eventual release.
