use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $modules = {};  my $manpage = {};
foreach my $module ( qw( TCB::PortMap TCB::System::Port ) ) { 
  my $file = $module;
     $file =~ s/::/\//g;  
     $file =~ s/$/.pm/;
  my $shortfile = $file;  $shortfile =~ s%^TCB/%%;
  my $libdir = join('/', '$(INST_LIBDIR)', $shortfile);
  my $man3 = join('/', '$(INST_MAN3DIR)', "$module.3");
  $$modules{$file} = $libdir; $$manpage{$file} = $man3;
}

my @progs;
foreach ( qw( htaccess-base htgroup-base htpasswd-base stylesheet.css
		portmap/portmap_admin.cgi portmap/portmap_user.cgi ) ) {
  push @progs, "cgi-bin/$_";
}
my $progs = [ @progs ] ;

WriteMakefile(
    'NAME'	=> 'TCB::PortMap',
    'DISTNAME'  => 'TCB-PortMap',
    'MAN3PODS'  => $manpage, 
    'VERSION_FROM' => 'Version.pm', # finds $VERSION
    'PREREQ_PM' => { 'DBIx::Frame' => 1.05 },
    'PM' 	=> $modules,
    'EXE_FILES' => $progs,
    'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
    'AUTHOR'    => 'tskirvin@ks.uiuc.edu (Tim Skirvin)',
    'ABSTRACT_FROM'  => 'TCB/PortMap.pm',
);
