#!/usr/local/bin/perl -Tw
use vars qw( $DBHOST $DBTYPE $DATABASE $DBUSER $DBPASS $DEBUG $CLASS $DB $HTML 
             $OPTIONS $TITLE @ACTIONS $HTMLHEAD $HTMLFOOT $VERSION $HTMLBODY 
	     $STYLESHEET );
$VERSION = "1.1";

=head1 NAME

library_user.cgi - Let users work with TCB::Library database

=head1 SYNOPSIS

Unfortunately, no URL is available for public use.  You can see the man
pages for DBIx::Frame::CGI for some details, otherwise you probably just
want to try it out.

=head1 DESCRIPTION

library_user.cgi is a customized version of DBIx::Frame's dbixframe.cgi
script, set up for internal use by the TCB Group to check out books and
see what they already have checked out.  It is fairly complicated to
explain, but it works well for internal use.

=head1 REQUIREMENTS

B<TCB::Library>

=head1 SEE ALSO

B<TCB::Library>, B<DBIx::Frame::CGI>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-library/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-library/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### CONFIGURATION + PRIVATE DATA ##############################################
###############################################################################

## Load shared configurations and/or private data using 'do' commands, as
## seen below.  Note that several 'do's can be run if necessary.  

# do '/FULL/PATH/TO/CODE/TO/RUN';       
use TCB::Internal;                              # Load &tbhtml_* commands

## This is the perl class that you will be using in this script.  

$CLASS   = "TCB::Library";                       # Database class

## Modify and uncomment this to use user code instead of just system-wide 
## modules.  Note that this path must be set up as a standard Perl tree;
## I'd personally recommend just installing things system-wide unless you're
## a developer.

# use lib '/PATH/TO/CODE';
# use lib '/home/tskirvin/dev/mdtools/tcb-library';

## Document title - set this as appropriate.

$TITLE   = "TCB Library";          

## Set these options to modify the behaviour of the HTML creation code.

$OPTIONS = {                                    
        'admin'    => 0,        # Offer 'edit' and 'delete' functions?
        'nodetail' => 1,        # Don't offer 'view'?
        'nocount'  => 0,        # Don't use 'next 25 entries' buttons
        'count'    => 25,       # How many entries should we offer at a time?
        'nomenu'   => 1,        # Don't offer the bottom menu
	'nosearchname' => 1,
           };

## Database Information
## You may want to set these with a common config file, using 'do FILE'.
## Also, defaults may already be set within the class; only set these if
## you want to override the defaults.

# $DBHOST   = "";               # System that hosts the database
# $DBTYPE   = "";               # The type of database that we're working on
# $DATABASE = "";               # Name of the database we're connecting to
# $DBUSER   = "";               # Username to connect to the database
# $DBPASS   = "";               # Password to connect to the database

do "/home/webserver/dbaccess/user.infoweb-admin"; # Populate DBUSER, DBPASS, etc

## This variable records how much debugging information you want in the
## HTML footers.  It works similarly to Unix permissions, by OR-ing the 
## appropriate options:
## 
##      1       Print SQL queries
##      2       Print CGI parameters
##      4       Print environment variables
##
## ie, '6' would print CGI and environment variables, and '5' would print 
## environment variables and SQL queries.  '0' will print nothing.

$DEBUG = 0;

## Modify this to change what default actions are available to manipulate
##  the availalbe databases - choose from 'list', 'create', and 'search'

@ACTIONS = qw( search );
                                
## These are references to code that will output the headers and footers
## for the messages.  If you want to change these, you can either modify
## the code (which is below) or create a new set of functions and change 
## the below code references appropriately.

# $HTMLHEAD = \&html_head;      
# $HTMLFOOT = \&html_foot;

$HTMLHEAD = \&tbhtml_head;
$HTMLFOOT = \&tbhtml_foot_database;

## Include the following in the TCB group header sidebars.

$ENV{'SIDEBAR'} = "<p> <a href='/Group/InfoWeb/Library/'>Library<br />Home</a> </p>";                                                                           

## Do we want to use a specific stylesheet?  This position is relative to
## wherever the script is being run.

$STYLESHEET = "stylesheet.css";

###############################################################################
### main() ####################################################################
###############################################################################

use CGI;
use DBIx::Frame::CGI; 
use strict;

# Load the appropriate class module
{ local $@; eval "use $CLASS";  die "$@\n" if $@; }

$0 =~ s%.*/%%g;		# Lose the annoying path information
my $cgi = new CGI || die "Couldn't open CGI";
$DB = $CLASS->connect( $DATABASE, $DBUSER, $DBPASS, $DBHOST, $DBTYPE )
        or Error("Couldn't connect to $DBHOST: $DBI::errstr\n");
my $error = $DBI::errstr;	# Avoid a warning, otherwise unnecessary
  
my $params = {};
foreach ($cgi->param) { $$params{$_} = $cgi->param($_); }
my $action = $cgi->param('action') || "";
my $table  = $cgi->param('table')  || "Book";
my $user   = $ENV{'REMOTE_USER'}   || $cgi->param('user') || "";

$$OPTIONS{'user'} = $user;
$$OPTIONS{'tdopts'} = 'align=left' if (lc $table eq 'book');
# Need to do something to have 'nowrap' where necessary

if (scalar @ACTIONS) { @DBI::Frame::ACTIONS = @ACTIONS }
my @test = @DBI::Frame::ACTIONS;        # Removing a warning

( print $cgi->header(), &$HTMLHEAD($TITLE, 
                        -style => {-src=>$STYLESHEET}), "\n" ) && $HTML++;

# Default: do a search of the database
if (lc $action eq 'search' || $action eq "") {
  print "<center><h2> Search the Library </h2></center>\n";
  print $DB->html_search($table, $params || {}, $OPTIONS);

# List specific sections of the database
} elsif (lc $action eq 'list') {
  $DB->set_list('Book', [
	{ 'Room' => '$$room$$' },
	{ 'Book' => \&book },	
        { 'Copy Status' => \&copystatus }
			] );
  print $DB->html_list($table, $params, $OPTIONS );

# Print a specific entry from the database
} elsif (lc $action eq 'print') {
  $DB->set_html( 'Book', \&TCB::Library::booklist_html );
  print $DB->html_view('Book', $params, $OPTIONS), "\n";

# Check out a book
} elsif (lc $action eq 'checkout') {
  print $DB->checkout(  $cgi->param('code') || "", $cgi->param('copy') || 1,
			$$OPTIONS{'user'} || "" );
  print "<center><h2> Search the Library </h2></center>\n";
  print $DB->html_search('Book', $params || {}, $OPTIONS);

# Check in a book
} elsif (lc $action eq 'checkin') { 
  print $DB->checkin(   $cgi->param('code') || "", $cgi->param('copy') || 1 );
  print "<center><h2> Search the Library </h2></center>\n";
  print $DB->html_search('Book', $params || {}, $OPTIONS);

# Steal a book from somebody else
} elsif (lc $action eq 'steal') { 
  print $DB->steal(     $cgi->param('code') || "", $cgi->param('copy') || 1,
		        $cgi->param('confirm') || 0, $$OPTIONS{'user'} ); 

} else { print "<h2>Bad action: '$action'</h2>"; }

# Print off information about the specific user's list of checked out books
unless ($user) {
  print <<NOUSER;
<h2>Please log in to the server</h2>

<form action='$0' method=post>
 <input type=text maxlength=15 name=user value='$user'>
 <input type=submit value="Login">
</form>
NOUSER
} elsif ( $ENV{'REMOTE_USER'} && $user ne $ENV{'REMOTE_USER'} ) {
  Error("'$ENV{REMOTE_USER}' and '$user' do not match");
} else {
  print $DB->checkout_by_user($user);
}

print &$HTMLFOOT($DEBUG);

exit(0);

###############################################################################
### Subroutines ###############################################################
###############################################################################

## book( ENTRY )
# Returns html-ready information on the book represented by ENTRY
sub book {
  my ($self, $entry) = @_;
  join("<br />", $self->linktitle($entry), "<i>$$entry{'author'}</i>");
}

## copystatus (ENTRY )
# Looks in the library for the current status of all copies of this book.
# Returns a list, separated with '<br />'
sub copystatus { 
  my ($self, $entry) = @_;
  my $copies = $$entry{'numcopy'} || 1;
  my $tbcode = $$entry{'code'}   || "unknown code";
  
  my %list;
  for my $i (1..$copies) {
    $list{$i} = 0;
    foreach my $lib ($self->select('Library',
                        { 'code' => $tbcode, 'copy' => $i } ) ) {
        $list{$i} = $$lib{name};
    }
  }

  my @list;
  foreach (sort keys %list) { 
    push @list, $list{$_} ? "#$_: <i>$list{$_}</i>"
			  : "#$_: in stock";
			
  }

  join("<br />", @list);
}

## Error ( PROBLEM [, PROBLEM [...]] )
# Prints an error message based on PROBLEM and exits.

sub Error {
  print CGI->header(), &$HTMLHEAD("Error in '$0'", 
                -style => {-src=>$STYLESHEET}) unless $HTML;

  print "This script failed for the following reasons: <p>\n<ul>\n";
  foreach (@_) { next unless $_; print "<li>", canon($_), "<br>\n"; }
  print "</ul>\n";

  print &$HTMLFOOT($DEBUG);
  exit 0;
}

## canon ( ITEM )
# Returns a printable version of whatever it's passed.  Used by Error().

sub canon {
  my $item = shift;
  if    ( ref($item) eq "ARRAY" )   { join(' ', @$item) }
  elsif ( ref($item) eq "HASH" )    { join(' ', %$item) }
  elsif ( ref($item) eq "" )        { $item }
  else                              { $item }
}

## html_head ( TITLE [, OPTIONS] )
# Prints off a basic HTML header, with debugging information.  Extra
# options are passed through to start_html.

sub html_head { 
  my $title = shift || $TITLE;
  use CGI;   my $cgi = new CGI;
  $cgi->start_html(-title => $title, @_) . "\n";
}

## html_foot ( DEBUG [, OPTIONS] )
# Prints off a basic HTML footer, with debugging information.

sub html_foot { 
  my $debug = shift || $DEBUG;
  use CGI;   my $cgi = new CGI;
  my @return = debuginfo($debug);
  push @return, $cgi->end_html(@_);
  join("\n", @return, "");
}

## debuginfo ( LEVEL ) 
# Takes care of printing debugging information, as described above

sub debuginfo {
  my $debug = shift || 0;

  my @return;
  if ($debug) { 
    push @return, "<hr />", "<h2> Debugging Information </h2>";

    if ($debug & 1) {
      push @return, "SQL Queries: <p>\n<ul>";
      foreach ($DB->queries) { push @return, " <li>$_" }
      push @return, "</ul>";
    }

    if ($debug & 2) {
      push @return,  "Parameters: <p>\n<ul>\n";
      foreach ($cgi->param) { push @return,  " <li>$_: ", $cgi->param($_); }
      push @return,  "</ul>";
    }

    if ($debug & 4) {
      push @return,  "Environment Variables: <p>\n<ul>";
      foreach (sort keys %ENV) { push @return, " <li>$_: $ENV{$_}"; }
      push @return,  "</ul>";
    }
    push @return, "<hr />";
  }

  wantarray ? @return : join("\n", @return);
}

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.9		Mon Oct 20 11:48:09 CDT 2003 
### Updating for the "new" DBI::Frame.  Also put the sub-functions into the
### module, which means this is a much smaller, cleaner CGI.
# v1.0		Tue Oct 21 14:48:16 CDT 2003 
### Getting ready for release.  Now using DBIx::Frame.
# v1.1		Wed May 19 14:49:08 CDT 2004 
### Forked from DBIx::Frame.  Now a part of TCB::Library.  Specific
### documentation added.
