use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $modules = {};  my $manpage = {};
foreach my $module ( qw( TCB::Library TCB::Library::Library 
			TCB::Library::Book TCB::Library::Functions ) ) {
  my $file = $module;
     $file =~ s/::/\//g;  
     $file =~ s/$/.pm/;
  my $shortfile = $file;  $shortfile =~ s%^TCB/%%;
  my $libdir = join('/', '$(INST_LIBDIR)', $shortfile);
  my $man3 = join('/', '$(INST_MAN3DIR)', "$module.3");
  $$modules{$file} = $libdir; $$manpage{$file} = $man3;
}

my $progs = [ qw( library_admin.cgi library_user.cgi library_list.cgi 
		  library_create.pl library_remind.pl ) ];

WriteMakefile(
    'NAME'	=> 'TCB::Library',
    'DISTNAME'  => 'TCB-Library',
    'MAN3PODS'  => $manpage, 
    'VERSION_FROM' => 'Version.pm', # finds $VERSION
    'PREREQ_PM' => { 'DBIx::Frame' => 1.05, 'Date::Parse' => '', 
		     'Mail::Send'  => '', 'Mail::Mailer' => '' },
    'PM' 	=> $modules,
    'EXE_FILES' => $progs,
    'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
    'AUTHOR'    => 'tskirvin@ks.uiuc.edu (Tim Skirvin)',
    'ABSTRACT_FROM'  => 'TCB/Library.pm',
);
