#!/usr/local/bin/perl -Tw 
use vars qw( $DBHOST $DBTYPE $DATABASE $DBUSER $DBPASS $DEBUG $CLASS $DB $HTML 
	     $OPTIONS $TITLE @ACTIONS $HTMLHEAD $HTMLFOOT $TABLE $ROOTCLASS 
	     $STYLESHEET $EMAIL ); 
our $VERSION = "1.0";

=head1 NAME

register.cgi - Conference registration for TCB::Conference

=head1 SYNOPSIS

Unfortunately, no URL is available for public use.  You can see the man
pages for DBIx::Frame::CGI for some details, otherwise you probably just
want to try it out.

=head1 DESCRIPTION

register.cig is used with TCB::Conference to actually register applicants
users for the conference.  It is a heavily customized version of
DBIx::Frame's dbixframe.cgi script, set up for external use.

=head1 REQUIREMENTS

B<TCB::Conference>, B<Mail::Mailer>

=head1 SEE ALSO

B<TCB::Conference>, B<DBIx::Frame::CGI>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/license.html>
for details.

=head1 COPYRIGHT

Copyright 2003-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Configuration + Private Data ##############################################
###############################################################################

## Load shared configurations and/or private data using 'do' commands, as
## seen below.  Note that several 'do's can be run if necessary.  

# do '/FULL/PATH/TO/CODE/TO/RUN';	
use TCB::Internal;				# Load &tbhtml_* commands

## This is the perl class that you will be using in this script.  

$CLASS   = "TCB::Conference";			# Database class

## This is the table that this script will work on.

$TABLE   = "Register";

## This is the email address we will mail to.  Make sure it's valid!

$EMAIL   = 'xxx@asdf.com.invalid';

## This is the root class of the above class.  Essentially a hack to let
## there be multiple modules using the same database.

$ROOTCLASS = "TCB::Conference";               # Class of the database class

## Modify and uncomment this to use user code instead of just system-wide 
## modules.  Note that this path must be set up as a standard Perl tree;
## I'd personally recommend just installing things system-wide unless you're
## a developer.

# use lib '/PATH/TO/CODE';
use lib '/home/tskirvin/dev/mdtools/tcb-conference';

## Document title - set this as appropriate.

$TITLE   = "Conference Registration Form";		

## Set these options to modify the behaviour of the HTML creation code.

$OPTIONS = { 					
	'admin'    => 0, 	# Offer 'edit' and 'delete' functions?
	'nodetail' => 0, 	# Don't offer 'view'?
	'nocount'  => 0,	# Don't use 'next 25 entries' buttons
	'count'    => 25,	# How many entries should we offer at a time?
	'nomenu'   => 1,	# Don't offer the bottom menu
	'quiet'	   => 1,	# 'Quiet' in the menus.
	'simple'   => 1,	# User information only - only for this DB
	   };

## Database Information
## You may want to set these with a common config file, using 'do FILE'.
## Also, defaults may already be set within the class; only set these if
## you want to override the defaults.

# $DBHOST   = "";		# System that hosts the database
# $DBTYPE   = "";		# The type of database that we're working on
# $DATABASE = "";		# Name of the database we're connecting to
# $DBUSER   = "";		# Username to connect to the database
# $DBPASS   = "";		# Password to connect to the database

do '/home/webserver/dbaccess/user.conference.public';   # Populate DBUSER, etc

## This variable records how much debugging information you want in the
## HTML footers.  It works similarly to Unix permissions, by OR-ing the 
## appropriate options:
## 
##    	1	Print SQL queries
##   	2	Print CGI parameters
##      4	Print environment variables
##
## ie, '6' would print CGI and environment variables, and '5' would print 
## environment variables and SQL queries.  '0' will print nothing.

$DEBUG   = 0;					

## Modify this to change what default actions are available to manipulate
##  the available databases - choose from 'list', 'create', and 'search'

# @ACTIONS = qw( create list search );
@ACTIONS = ();
				
## These are references to code that will output the headers and footers
## for the messages.  If you want to change these, you can either modify
## the code (which is below) or create a new set of functions and change 
## the below code references appropriately.

# $HTMLHEAD = \&html_head;	
# $HTMLFOOT = \&html_foot;

$HTMLHEAD = \&tbhtml_head_service;
$HTMLFOOT = \&tbhtml_foot_service;

## Do we want to use a specific stylesheet?  This position is relative to
## wherever the script is being run.

$STYLESHEET = "stylesheet.css";

###############################################################################
### main() ####################################################################
###############################################################################

use Mail::Mailer;
use DBIx::Frame::CGI;
use strict;

# Load the appropriate class module
{ local $@; eval "use $CLASS";  die "$@\n" if $@; }

my $cgi = new CGI || die "Couldn't open CGI";
$DB = $CLASS->connect( $DATABASE, $DBUSER, $DBPASS, $DBHOST, $DBTYPE )
	or Error("Couldn't connect to $DBHOST: $DBI::errstr\n");
my $error = $DBI::errstr;	# Avoid a warning, otherwise unnecessary

$0 =~ s%.*/|\?.*%%g;		# Lose the annoying path information

my $params = {};
foreach ($cgi->param) { $$params{$_} = $cgi->param($_); }
my $action = $cgi->param('action') || "";
my $table  = $TABLE || $cgi->param('table') || "";

( print $cgi->header(), &$HTMLHEAD($TITLE, 
                        -style => {-src=>$STYLESHEET}), "\n" ) && $HTML++;

if ($action eq 'insert') {
  $DB->insert($table, $params) || Error($DB->error);

  print <<HTML;

<p> Thank you!  Your application has been received.  We will shortly send
you an e-mail with your application information and additional details.
Please keep this email as your receipt.  </p>

<p> Summer School Organizers <br> 
    sumschool03\@ks.uiuc.edu <br>
    ph# 217/244-2212 </p>

HTML

  my $email = $$params{'Email'} || Error("No email address offered");

  my $mailer = new Mail::Mailer 'sendmail';
  $mailer->open( { 
	'Subject' => "Receipt confirmation for TCB Summer School '03",
	'From'    => $EMAIL, 
	'To'	  => $$params{'Email'},
	'Cc' 	  => $EMAIL, 
		 } );

  my @info;
  my $name = join(' ', $$params{'FirstName'} || 'FIRST', 
		       $$params{'LastName'}  || 'LAST' );
  push @info, "Name: $name";
  push @info, "Email: $email";
  push @info, "Company/Institution: " . $$params{'Institution'} || "";
  push @info, "Department: " . $$params{'Department'} || "";
  push @info, "Title: " . $$params{'Title'} || "";
  my $city = $$params{'City'} || "Unknown City";
  my $state = $$params{'State'} || "Unknown State";
  my $zip = $$params{'Zip'} || "Unknown Zip";
  push @info, "Mailing Address: " . $$params{'StreetAdd'} || "";
  push @info, "	         $city, $state $zip";
  push @info, "                 $$params{'Country'}" if $$params{'Country'};
  push @info, $$params{'Gender'} ? "Gender: Male" 
				 : "Gender: Female";
  push @info, "Citizenship: " . $$params{'Citizenship'} || "";
  push @info, "Race: " . $$params{'Race'} || "";
  if ($$params{'Housing'} eq 'Hendrick') { 
    my $roommate = $$params{'Roommate'} || "Random";
    push @info, "Housing: I will be staying at Hendrick House.";
    push @info, "         I would like my roommate to be '$roommate'";
  } else { 
    push @info, "Housing: I will arrange for my own housing arrangements.";
  }
  push @info, "Notes: ", $$params{'Notes'} || "";

  print $mailer <<MAIL;

Thank you for submitting your application for the Summer School on
Theoretical and Computational Biophysics at UIUC.  The information we have
received from you:

@{[ join("\n", @info) ]}

This email is your receipt for your application.  When your participation
has been approved (by Apr 15th) you will be contacted at this email
address with additional technical and administrative arrangements.

Once your participation is confirmed, you will be required to mail your
registration fee using a certified check (made out to the "University of
Illinois") to:

Marilyn Lynch
3125 Beckman Institute
405 N Mathews Ave
Urbana, IL 61801

If you need to modify your registration information at any point after
submitting your application, please contact the summer school organizers
at sumschool03\@ks.uiuc.edu with all necessary details. 

Thank you so much, 
			Summer School Organizers
MAIL

  $mailer->close;

} else { 
  print "<p align=center>Applications received after April 2 will be
		considered on a space-available basis</p>\n";
  print $DB->html_create($table, $params, $OPTIONS) ; 
  print "<p align=center>If you experience technical problems in
		completing this form, please contact us 
		at sumschool03\@ks.uiuc.edu</p>\n";
}

print &$HTMLFOOT();
exit(0);

###############################################################################
### Subroutines ###############################################################
###############################################################################

## Error ( PROBLEM [, PROBLEM [...]] )
# Prints an error message based on PROBLEM and exits.

sub Error {
  print CGI->header(), &$HTMLHEAD("Error in '$0'", 
                -style => {-src=>$STYLESHEET}) unless $HTML;

  print "This script failed for the following reasons: <p>\n<ul>\n";
  foreach (@_) { next unless $_; print "<li>", canon($_), "<br>\n"; }
  print "</ul>\n";

  print &$HTMLFOOT($DEBUG);
  exit 0;
}

## canon ( ITEM )
# Returns a printable version of whatever it's passed.  Used by Error().

sub canon {
  my $item = shift;
  if    ( ref($item) eq "ARRAY" )   { join(' ', @$item) }
  elsif ( ref($item) eq "HASH" )    { join(' ', %$item) }
  elsif ( ref($item) eq "" )        { $item }
  else                              { $item }
}

## html_head ( TITLE [, OPTIONS] )
# Prints off a basic HTML header, with debugging information.  Extra
# options are passed through to start_html.

sub html_head { 
  my $title = shift || $TITLE;
  use CGI;   my $cgi = new CGI;
  $cgi->start_html(-title => $title, @_) . "\n";
}

## html_foot ( DEBUG [, OPTIONS] )
# Prints off a basic HTML footer, with debugging information.

sub html_foot { 
  my $debug = shift || $DEBUG;
  use CGI;   my $cgi = new CGI;
  my @return = debuginfo($debug);
  push @return, $cgi->end_html(@_);
  join("\n", @return, "");
}

## debuginfo ( LEVEL ) 
# Takes care of printing debugging information, as described above

sub debuginfo {
  my $debug = shift || 0;

  my @return;

  if ($debug & 1) {
    push @return, "SQL Queries: <p>\n<ul>";
    foreach ($DB->queries) { push @return, " <li>$_" }
    push @return, "</ul>";
  }

  if ($debug & 2) {
    push @return,  "Parameters: <p>\n<ul>\n";
    foreach ($cgi->param) { push @return,  " <li>$_: ", $cgi->param($_); }
    push @return,  "</ul>";
  }

  if ($debug & 4) {
    push @return,  "Environment Variables: <p>\n<ul>";
    foreach (sort keys %ENV) { push @return, " <li>$_: $ENV{$_}"; }
    push @return,  "</ul>";
  }

  wantarray ? @return : join("\n", @return);
}

###############################################################################
### Version History ###########################################################
###############################################################################
# v1.0a		Thu Jul 12 14:06:12 CDT 2001
### Release candidate.  Internal documentation written, it seems modular.
# v1.0		Wed May 26 13:50:32 CDT 2004 
### Now a part of DBIx::Frame.
