#!/usr/local/bin/perl 
use vars qw( $DBHOST $DBTYPE $DATABASE $DBUSER $DBPASS $DEBUG $CLASS $DB $HTML 
             $OPTIONS $TITLE @ACTIONS $HTMLHEAD $HTMLFOOT );
our $VERSION = "1.0";

=head1 NAME

list.cgi - get all information from TCB::Conference

=head1 SYNOPSIS

  ./list.cgi

Meant to be used on the web.

=head1 DESCRIPTION

list.cgi is used to list all information of attendees in
TCB::Conference. 

=head1 REQUIREMENTS

B<TCB::Conference>

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/license.html>
for details.

=head1 COPYRIGHT

Copyright 2003-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut


###############################################################################
### Configuration + Private Data ##############################################
###############################################################################

## Load shared configurations and/or private data using 'do' commands, as
## seen below.  Note that several 'do's can be run if necessary.  

# do '/FULL/PATH/TO/CODE/TO/RUN';	

## This is the perl class that you will be using in this script.  

$CLASS   = "TCB::Conference";			# Database class

## Modify and uncomment this to use user code instead of just system-wide 
## modules.  Note that this path must be set up as a standard Perl tree;
## I'd personally recommend just installing things system-wide unless you're
## a developer.

# use lib '/PATH/TO/CODE';
use lib '/home/tskirvin/dev/mdtools/tcb-conference';

## Document title - set this as appropriate.

$TITLE   = "Conference Database";		

## Set these options to modify the behaviour of the HTML creation code.

$OPTIONS = { 					
	'admin'    => 0, 	# Offer 'edit' and 'delete' functions?
	'nodetail' => 1, 	# Don't offer 'view'?
	'nocount'  => 1,	# Don't use 'next 25 entries' buttons
	'count'    => 500,	# How many entries should we offer at a time?
	'nomenu'   => 1,	# Don't offer the bottom menu
	   };

## Database Information
## You may want to set these with a common config file, using 'do FILE'.
## Also, defaults may already be set within the class; only set these if
## you want to override the defaults.

# $DBHOST   = "";		# System that hosts the database
# $DBTYPE   = "";		# The type of database that we're working on
# $DATABASE = "";		# Name of the database we're connecting to
# $DBUSER   = "";		# Username to connect to the database
# $DBPASS   = "";		# Password to connect to the database

do '/home/webserver/dbaccess/user.conference.admin'; # Populate DBUSER, etc

## This variable records how much debugging information you want in the
## HTML footers.  It works similarly to Unix permissions, by OR-ing the 
## appropriate options:
## 
##    	1	Print SQL queries
##   	2	Print CGI parameters
##      4	Print environment variables
##
## ie, '6' would print CGI and environment variables, and '5' would print 
## environment variables and SQL queries.  '0' will print nothing.

$DEBUG   = 0;					

## Modify this to change what default actions are available to manipulate
##  the availalbe databases - choose from 'list', 'create', and 'search'

@ACTIONS = qw( create list search );
				
## These are references to code that will output the headers and footers
## for the messages.  If you want to change these, you can either modify
## the code (which is below) or create a new set of functions and change 
## the below code references appropriately.

$HTMLHEAD = \&html_head;	
$HTMLFOOT = \&html_foot;

###############################################################################
### main() ####################################################################
###############################################################################

use warnings;
use CGI;
use DBIx::Frame::CGI;
use strict;

# Load the appropriate class module
{ local $@; eval "use $CLASS";  die "$@\n" if $@; }

$0 =~ s%.*/%%g;		# Lose the annoying path information
my $cgi = new CGI || die "Couldn't open CGI";
$DB = $CLASS->connect( $DATABASE, $DBUSER, $DBPASS, $DBHOST, $DBTYPE )
	or Error("Couldn't connect to $DBHOST: $DBI::errstr\n");
my $error = $DBI::errstr;	# Avoid a warning, otherwise unnecessary

my $params = {};
foreach ($cgi->param) { $$params{$_} = $cgi->param($_); }
my $action = $cgi->param('action') || "list";
my $table = "Register";

$DB->set_list( 'Register', [
        { 'Name' => '$$FirstName$$ $$LastName$$' },
        # { 'Email' => '$$Email$$' },
        { 'US?'  => \&us_vs_no },
        'Title',
        { 'Affiliation' => '$$Institution$$ <br /> $$Department$$' },
                           ] );

$DB->set_html( 'Register', \&html );

print "Content-type: text/html\n\n";
print "<h2> Final Summer School Participants </h2>\n";
print "<table>\n";
foreach my $item ( $DB->select( $table, { 'Approved' => "1" } ) ) { 
  foreach (keys %{$item}) { 
    next unless $$item{$_};
    $$item{$_} =~ s/,/ /;
  }
  my $output = join('</td><td align=left>', $DB->make_list($table,$item));
  # $output =~ s/\</\&lt\;/g;
  # $output =~ s/\>/\&gt\;/g;
  print "<tr>\n";
  print " <td align=center>$output</td>\n";
  print "</tr>\n";
}
print "</table>\n";

exit(0);

###############################################################################
### Subroutines ###############################################################
###############################################################################

## Error ( PROBLEM [, PROBLEM [...]] )
# Prints an error message based on PROBLEM and exits.

sub Error {
  print CGI->header(), &$HTMLHEAD("Error in '$0'") unless $HTML;

  print "This script failed for the following reasons: <p>\n<ul>\n";
  foreach (@_) { next unless $_; print "<li>", canon($_), "<br>\n"; }
  print "</ul>\n";

  print &$HTMLFOOT($DEBUG);
  exit 0;
}

## canon ( ITEM )
# Returns a printable version of whatever it's passed.  Used by Error().

sub canon {
  my $item = shift;
  if    ( ref($item) eq "ARRAY" )   { join(' ', @$item) }
  elsif ( ref($item) eq "HASH" )    { join(' ', %$item) }
  elsif ( ref($item) eq "" )        { $item }
  else                              { $item }
}

## html_head ( TITLE [, OPTIONS] )
# Prints off a basic HTML header, with debugging information.  Extra
# options are passed through to start_html.

sub html_head { 
  my $title = shift || $TITLE;
  use CGI;   my $cgi = new CGI;
  $cgi->start_html(-title => $title, @_) . "\n";
}

## html_foot ( DEBUG [, OPTIONS] )
# Prints off a basic HTML footer, with debugging information.

sub html_foot { 
  my $debug = shift || $DEBUG;
  use CGI;   my $cgi = new CGI;
  my @return = debuginfo($debug);
  push @return, $cgi->end_html(@_);
  join("\n", @return, "");
}

## debuginfo ( LEVEL ) 
# Takes care of printing debugging information, as described above

sub debuginfo {
  my $debug = shift || 0;

  my @return;

  if ($debug & 1) {
    push @return, "SQL Queries: <p>\n<ul>";
    foreach ($DB->queries) { push @return, " <li>$_" }
    push @return, "</ul>";
  }

  if ($debug & 2) {
    push @return,  "Parameters: <p>\n<ul>\n";
    foreach ($cgi->param) { push @return,  " <li>$_: ", $cgi->param($_); }
    push @return,  "</ul>";
  }

  if ($debug & 4) {
    push @return,  "Environment Variables: <p>\n<ul>";
    foreach (sort keys %ENV) { push @return, " <li>$_: $ENV{$_}"; }
    push @return,  "</ul>";
  }

  wantarray ? @return : join("\n", @return);
}

sub gender { my $gender = shift; $gender ? "Male" : "Female" }
sub accepted { my ($info) = @_;  
  $$info{'Approved'} ||= "";
  return "Accepted" if $$info{'Approved'} eq 1;
  return "Not Accepted" if $$info{'Approved'} eq -1;
  return "Undecided" if $$info{'Approved'} eq 0;
  return "Undecided";
}

sub us_vs_no {
  my ($self, $info) = @_;  
  my $country = $$info{Country} || "usa";
  $country =~ s/\.//g;
  $country =~ s/usa/us/gi;
  $country =~ s/united states/us/gi;
  $country =~ s/^us$/USA/gi;
  $country =~ s/canada/Canada/gi;
  $country =~ s/united kingd.*/UK/gi;
  $country;
  # lc $country eq 'us' ? 1 : 0;
}

sub html {
  my ($self, $entry, $type, $options, @rest) = @_;

  my %approved = ( -1 => 'Unapproved', 1 => 'Approved', 0 => 'Not Yet' );
  $approved{''} = "*";
  # $approved{'%'} = "*";

  my $cgi = new CGI;
  return <<HTML;
<table width=100%>
 <tr> 
  <td> Approved? </td>
  <td align=center>
     @{[ $cgi->radio_group('Approved', [ keys %approved ],
                                 $$entry{Approved}, 0, \%approved) ]}
  </td> <td> @{[ $cgi->submit(-name=>"Submit") ]} </td> 
 </tr>
</table>
HTML
}

###############################################################################
### Version History ###########################################################
###############################################################################
# v1.0a		Thu Jul 12 14:06:12 CDT 2001
### Release candidate.  Internal documentation written, it seems modular.
# v1.0		Wed May 26 13:11:34 CDT 2004 
### Actually releasing this.  Has comments now.
