$VERSION = "0.5";
package TCB::Conference;
our $VERSION = "0.5";

# -*- Perl -*- 		Wed May 26 10:32:35 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2003-2004, Tim Skirvin and UIUC Board of Trustees.
###############################################################################

=head1 NAME

TCB::Conference::Functions - dditional functions for TCB::Conference

=head1 SYNOPSIS

  use TCB::Conference::Functions;

See TCB::Conference for general information on this database.

=head1 DESCRIPTION

TCB::Conference::Functions contains shared functions specific to
TCB::Conference. These are a combination of specific functions for each
table and general extensions to DBIx::Frame.  

=cut

###############################################################################
### main() ####################################################################
###############################################################################

use TCB::Conference;
use Exporter;

use vars qw( @EXPORT_OK @EXPORT );
use strict;
use CGI;

###############################################################################
##### Functions ###############################################################
###############################################################################

=head2 Functions

The following methods are available within this object, and are exported
by default:

=over 4

=item created_html ( CREATEDATE, MODIFYDATE, CREATEBY, MODIFYBY, NOSHOW )

Returns the standard little table for Date and Person vs Created and
Modified, along with the 'Submit' button.  Used by several of the tables,
we might as well share the code between them, but this is still private
code.  NOSHOW, if set, says "don't show them the table".

=cut

sub created_html {
  my $cgi = new CGI;
  my ($self, $createdate, $modifydate, $createdby, $modifiedby, $noshow) = @_;
  $createdate ||= "";  $modifydate ||= "";
  $createdby  ||= "";  $modifiedby ||= "";
  my @return;
  push @return, $cgi->hidden('CreateDate', $createdate),
                $cgi->hidden('ModifyDate', $modifydate),
                $cgi->hidden('CreatedBy',  $createdby ),
                $cgi->hidden('ModifiedBy', $modifiedby);
  return @return if $noshow;
  push @return, <<END;
     <table class="modbox" border>
      <tr> <th> </th> <th>Created</th> <th>Modified</th> </tr>
      <tr> <th>Date</th>
           <td align=center>@{[ $createdate ]}</td>
           <td align=center>@{[ $modifydate ]}</td> 
           </tr>
      <tr> <th>Person</th>
           <td align=center>@{[ $createdby  ]}</td>
           <td align=center>@{[ $modifiedby ]}</td>  
           </tr>
     </table>
END
  @return;
}


=item date_mysql ( [TIME] )

Returns the date based on B<TIME> for use with mysql.  If B<TIME> is not
passed, just uses the current time.

=cut

sub date_mysql {
  my ($self, $time) = @_;  $time ||= time;
  sprintf("%04d-%02d-%02d", (localtime($time))[5] + 1900,
                        (localtime($time))[4] + 1, (localtime($time))[3]);
}

=back

=cut

1;

=head1 REQUIREMENTS

Perl 5.6.1 or better, DBIx::Frame 1.05 or better, TCB::Conference.

=head1 SEE ALSO

B<TCB::Conference>, B<DBIx::Frame>

=head1 AUTHOR

Tim Skirvin <tskirvin@ks.uiuc.edu>

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/license.html>
for details.

=head1 COPYRIGHT

Copyright 2003-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.0.1	Wed Jan 15 14:29:49 CST 2003
### Just date_mysql().
# v0.5		Wed May 26 10:35:24 CDT 2004 
### Updated for DBIx::Frame.
