$VERSION = "0.5";
package TCB::Conference;
our $VERSION = "0.5";

# -*- Perl -*- 		Wed May 26 10:27:46 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.  All rights reserved.
# Copyright 2003-2004, Tim Skirvin and UIUC Board of Trustees.
###############################################################################

=head1 NAME

TCB::Conference - registration for the TCB Summer School '03

=head1 SYNOPSIS

  use TCB::Conference;
  TCB::Conference->init('server', 'dbtype') || exit(0);
  my $DB = TCB::Conference->new('database', 'user', 'pass')
        or die("Couldn't connect to database: " DBI->errstr);

See below for how to actually use this object.

=head1 DESCRIPTION

TCB::Conference is a DBIx::Frame object used to register and track
external users registering for the TCB Summer School, which took place in
Summer 2003.  It may still be useful for other purposes, so we will
distribute it.  It consists of a series of public CGI scripts that load
this information from a central database, several more scripts that are
used internally to track the information, and some perl modules that tie
it all together.

This base class is used to load the table definitions and basic functions
for the database.  

Specific tables offered by this class:

=over 4

=item TCB::Conference::Register - base registration database

=item TCB::Conference::Register_noedit - a copy of the above data

=back

See each table's documentation for more information.

Additional functions are offered in B<TCB::Conference::Functions>.

=cut

use strict;
use vars qw(@ISA @PROBS @MODULES $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG );

###############################################################################
### User Variables ############################################################
###############################################################################
@MODULES  = qw( DBIx::Frame Exporter TCB::Conference::Functions 
		TCB::Conference::Register TCB::Conference::Register_noedit );
@ISA      = qw( DBIx::Frame Exporter );
$SERVER   = "db.ks.uiuc.edu";                        # Default web server
$DATABASE = "Conference";
$DBTYPE   = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;

###############################################################################
### main() ####################################################################
###############################################################################
foreach ( @MODULES ) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if scalar @PROBS;

# Initialize DBIx::Frame (this has already been done a few times, but this
#   allows us to have a definite known state to finish with)
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);
###############################################################################

1;

=head1 NOTES

These tables were designed by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>

=head1 SEE ALSO

B<DBIx::Frame>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-conference/license.html> for
details.

=head1 COPYRIGHT

Copyright 2003-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.1		Tue Oct 15 16:00:48 CDT 2002
### Getting ready for the future.
# v0.2		Wed May 26 10:27:46 CDT 2004 
### Updated for DBIx::Frame and release.
