$VERSION = "2.0";
package TCB::AddressBook;
our $VERSION = "2.0";

# -*- Perl -*- 		Wed May 19 16:04:37 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################

=head1 NAME

TCB::AddressBook - an interface for the TCB Group's Address Book

=head1 SYNOPSIS

  use TCB::AddressBook;
  my $DB = TCB::AddressBook->connect( $DATABASE, $DBUSER, $DBPASS, 
                                                  $DBHOST, $DBTYPE )
        or die("Couldn't connect to $DBHOST: $DBI::errstr\n");

See below for how to actually use this object.

=head1 DESCRIPTION

TCB::AddressBook is a basic database-backed address book, in this case
written for the Theoretical Biophysics Group at the University of
Illinois.  It is written for DBIx::Frame - more information can be found
on that page.

Specific tables:

=over 4

=item TCB::AddressBook::SBook - actual address information

=back

See each table's documentation for more information.

=cut

use strict;
use vars qw( @MODS $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG @ISA @PROBS );

###############################################################################
### User Variables ############################################################
###############################################################################

@MODS     = qw( DBIx::Frame Exporter TCB::AddressBook::SBook );
@ISA      = qw( DBIx::Frame Exporter );
$SERVER   = "db.ks.uiuc.edu";	        # Default web server 
$DATABASE = "UserDB";	     
$DBTYPE	  = "mysql";
$USER     = "sbook-guest";
$PASS     = "";
$DEBUG    = 0;

###############################################################################
### main () ###################################################################
###############################################################################

# Load the necessary modules from @MODS
foreach (@MODS) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if @PROBS;

# Initialize DBIx::Frame
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);

1;

=head1 NOTES

These tables were designed a long time ago by parties unknown.  They are
virtually worthless for anything but the web application that they were
originally designed for; there is no way of parsing the information
consistently, because the data that is entered in is not stored
consistently.  The TCB Group has begun using an LDAP database instead, and
is not looking back.

=head1 REQUIREMENTS

Perl 5 or better, and DBIx::Frame.  

=head1 SEE ALSO

B<DBIx::Frame>, B<DBIx::Frame::CGI>, B<tbtel>, B<TCB::AddressBook::SBook>

=head1 AUTHOR

Tim Skirvin <tskirvin@ks.uiuc.edu>

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-addressbook/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-addressbook/license.html> for
details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.9		???
### Initial Release.  
# v1.5	 	Thu Jul 26 09:50:44 CDT 2001
### Put the code base into DBI::Frame base, and commented the code.  Created
### the various .cgi files associated with the package.
# v2.0		Wed May 19 16:18:10 CDT 2004 
### Updating for DBIx::Frame.  
