/*
 * getdate.h
 *
 * author:  David Hardy
 *
 * Returns date and time in form:  "YYYY-MM-DD HH:MM:SS"
 */


#include <stdio.h>
#include <time.h>
#include "getdate.h"


/*
 * hash table for converting 3-letter month into 2-digit number
 */
static const char *MonthNum[] = {
  "",    /*     */
  "",    /*     */
  "",    /*     */
  "01",  /* Jan */
  "07",  /* Jul */
  "04",  /* Apr */
  "06",  /* Jun */
  "03",  /* Mar */
  "11",  /* Nov */
  "09",  /* Sep */
  "",    /*     */
  "10",  /* Oct */
  "02",  /* Feb */
  "12",  /* Dec */
  "05",  /* May */
  "",    /*     */
  "08",  /* Aug */
};


int get_date(char *strbuf)
/*
 * assume that strbuf has space for at least 20 characters
 */
{
#define  BUFLEN  32

  char buf[BUFLEN];
  char *month_str, *day_str, *time_str, *year_str;
  int index;
  time_t tsec;

  (void) time(&tsec);          /* time in seconds since the Epoch */
  strcpy(buf, ctime(&tsec));   /* express date as a string */

  /*
   * convert date string fixed column form:  "Wed Jan 10 15:39:20 2001\n"
   *                                    to:  "2001-01-10 15:39:20"
   */
#define  MONTH_OFFSET     4
#define  DAY_OFFSET       8
#define  TIME_OFFSET     11
#define  YEAR_OFFSET     20
#define  NEWLINE_OFFSET  24

  month_str = &buf[MONTH_OFFSET];
  buf[DAY_OFFSET-1] = '\0';
  day_str = &buf[DAY_OFFSET];
  buf[TIME_OFFSET-1] = '\0';
  time_str = &buf[TIME_OFFSET];
  buf[YEAR_OFFSET-1] = '\0';
  year_str = &buf[YEAR_OFFSET];
  buf[NEWLINE_OFFSET] = '\0';
  if (day_str[0] == ' ')  day_str[0] = '0';

  /*
   * homemade hash function to convert 3-letter month into 2-digit number
   */
  index = ((int) (month_str[1] + month_str[2])) % 17;

  sprintf(strbuf, "%s-%s-%s %s", year_str, MonthNum[index], day_str, time_str);
  return 0;
}
