
/** Little applet to check and see whether or not the user has Swing
 *  up and running correctly in their browser.  See the README file
 *  that came with this file for instructions on compiling and accessing
 *  this applet.
 *
 * @author Kirby Vandivort (kvandivo@ks.uiuc.edu) 
 *
 *     http://www.ks.uiuc.edu/Development/MDTools/swingtest/
 *
 * Copyright (c) 2001 The Board of Trustees of the University of Illinois
 * and others.     
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.applet.*;


public class SwingTest extends Applet implements ActionListener
{
   // ----------------------------------------------------------------------
   public void init()
   {
      String strClass = "javax.swing.JLabel";  // test class
      boolean bHaveLink = false;   // do they want to provide links
      boolean bDontHaveLink = true;   // do they want to provide links

      String strHaveSwing = "You Have Swing"; // default value
      String strDontHaveSwing = "You're not ready!"; // default value

      // -------- Get all of the parameters that have been passed in -----
      // -------
      if (getParameter("haveSwingMsg") != null)
         strHaveSwing = getParameter("haveSwingMsg");

      // -------
      if (getParameter("dontHaveSwingMsg") != null)
         strDontHaveSwing = getParameter("dontHaveSwingMsg");

      // -------
      if (getParameter("provideHaveLink") != null)
      {
         if (getParameter("provideHaveLink").equals("false"))
           bHaveLink = false; 
      }

      if (getParameter("haveUrl") != null)
         m_strHaveUrl = getParameter("HaveUrl");

      // -------
      if (getParameter("provideDontHaveLink") != null)
      {
         if (getParameter("provideDontHaveLink").equals("false"))
           bDontHaveLink = false; 
      }

      if (getParameter("dontHaveUrl") != null)
         m_strDontHaveUrl = getParameter("dontHaveUrl");

      
      // -------- Test for Swing -------
      // -------
      try {
         Class.forName(strClass);

         // if we make it to this line, then they have swing.
         m_bSwing = true;
      } catch (Exception e)
      {  // no Swing.  
         m_bSwing = false;
      }

      // -------- Present User with answer -------
      // Now we know..  We have to decide what we want to do about it,
      // though
      if (m_bSwing)
      {
         if (bHaveLink)
         {
            Button b = new Button(strHaveSwing);
            b.addActionListener(this);
            add(b, java.awt.BorderLayout.CENTER);
         }
         else
         {
            add(new Label(strHaveSwing));
         }
      }
      else
      {
         if (bDontHaveLink)
         {
            Button b = new Button(strDontHaveSwing);
            b.addActionListener(this);
            add(b, java.awt.BorderLayout.CENTER);
         }
         else
         {
            add(new Label(strDontHaveSwing));
         }
      }

   } // end of init()

   // ----------------------------------------------------------------------
   public void actionPerformed(ActionEvent et)
   {
      String strUrl = "";

      // figure out which button they had..
      if (m_bSwing)
         strUrl = m_strHaveUrl;
      else
         strUrl = m_strDontHaveUrl;

      try {
         getAppletContext().showDocument(new URL(strUrl));
      } catch (Exception e) {
         System.out.println("Problem with spawning " + strUrl);
      }
   } // end of actionPerformed
   // ----------------------------------------------------------------------

   private String m_strDontHaveUrl = // default value
              "http://www.ks.uiuc.edu/Research/biocore/swing_setup.shtml";

   private String m_strHaveUrl = // default value
              "http://www.ks.uiuc.edu/Research/biocore/";

   private boolean m_bSwing = false;
} // end of SwingTest class
