
/** Tiny little class to check and see whether or not the user has Swing
 *  up and running correctly in their browser.
 *  To compile:
 *       javac SwingTest.java
 *
 *  HTML to get everything working properly:
 * <PRE>
   <APPLET CODE=SwingTest WIDTH=200 HEIGHT=30>
   You don't seem to have Java enabled.  Please enable it and reload this page.
   </APPLET> 
   </PRE>
 * @author Kirby Vandivort (kvandivo@ks.uiuc.edu)
 *
 * Copyright (c) 2001 The Board of Trustees of the University of Illinois
 * and others.     
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.applet.*;


public class SwingTest extends Applet implements ActionListener
{
   public void init()
   {
      String strClass = "javax.swing.JLabel";
      boolean bSwing = false;

      try {
         Class.forName(strClass);

         // if we make it to this line, then they have swing.
         bSwing = true;
      } catch (Exception e)
      {  // no Swing.  
         bSwing = false;
      }

      if (bSwing)
      {
         add(new Label("You Have Swing"));
      }
      else
      {
         Button b = new Button("You're not ready!");
         b.addActionListener(this);
         add(b, java.awt.BorderLayout.CENTER);
      }

   } // end of init()

   public void actionPerformed(ActionEvent et)
   {
      String strUrl = 
              "http://www.ks.uiuc.edu/Research/biocore/swing_setup.shtml";
      try {
         getAppletContext().showDocument(new URL(strUrl));
      } catch (Exception e) {
         System.out.println("Problem with spawning " + strUrl);
      }
   }
} // end of SwingTest class
