=head1 NAME

Mail::SpamAssassin::Plugin::UIUC - use UIUC's Spam Control service

=head1 SYNOPSIS

  loadplugin     Mail::SpamAssassin::Plugin::UIUC

=head1 DESCRIPTION

The University of Illinois at Urbana-Champaign is using the Proofpoint
spam-filtering service to remove viruses and spam as part of the CITES Spam
Control Service (CSC).  This plugin to SpamAssassin uses the resultant headers
(X-Spam-Score and X-Spam-Details) to further score incoming messages that have
gone through the CSC system.

=head1 NOTES

I would like to put the actual URL of the spam-filtering service here.

=head1 REQUIREMENTS

B<Mail::SpamAssassin> (was written for 3.0.2)

=head1 AUTHOR

Tim Skirvin <tskirvin@ks.uiuc.edu>

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/spamassassin-uiuc/>

=head1 LICENSE

For compatibility with SpamAssassin, this package is distributed under the
Apache License v2.0 (B<http://www.apache.org/licenses/LICENSE-2.0>).

=head1 COPYRIGHT

Copyright 2005 by the University of Illinois Board of Trustees and Tim Skirvin
<tskirvin@ks.uiuc.edu>.

=cut

# <@LICENSE>
# Copyright 2005, Tim Skirvin and University of Illinois at Urbana-Champaign
#                 Board of Trustees
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# </@LICENSE>

package Mail::SpamAssassin::Plugin::UIUC;

our $VERSION = "0.52";

use Mail::SpamAssassin::Plugin;
use Digest::SHA1 qw(sha1);
use Fcntl;
use File::Path;
use File::Basename;
use strict;
use bytes;

use vars qw(@ISA);
@ISA = qw(Mail::SpamAssassin::Plugin);

# constructor: register the eval rule
sub new {
  my $class = shift;
  my $mailsaobject = shift;

  # some boilerplate...
  $class = ref($class) || $class;
  my $self = $class->SUPER::new($mailsaobject);
  bless ($self, $class);

  my $conf = $mailsaobject->{conf};
  $conf->{use_uiuc_spamfilter} = 1;
  $conf->{uiuc_headers} = [ 'X-Spam-Score', 'X-Spam-Details'];

  $self->register_eval_rule ("check_uiuc_spam");

  return $self;
}

###########################################################################

sub parse_config {
  my ($self, $opts) = @_;
  my $conf = $opts->{conf};
  my $key = $opts->{key};
  my $value = $opts->{value};
  return 0;
}

###########################################################################

=over 4

=cut

sub check_uiuc_spam {
  my ($self, $scanner, $low, $high) = @_;
  # Actually check the X-Spam-Status score
  my $hdr_value = $scanner->{msg}->get_pristine_header('X-Spam-Score');
  return 0 unless defined $hdr_value;   
  $hdr_value =~ s/^([\d\.-]+)\s+$/$1/m;		# Trim all non-numbers
  return 0 unless $hdr_value =~ m/^[\d\.-]+/; 
  return 0 if $hdr_value <= $low;
  return 0 if $hdr_value > $high; 
  return 1;
} 

############################################################################

sub dbg { Mail::SpamAssassin::dbg (@_); }

1;

###############################################################################
### Version History ###########################################################
###############################################################################
# 0.50		Thu Mar 17 11:03:13 CST 2005 	tskirvin@ks.uiuc.edu
### Initial version.
# 0.51		Thu Mar 17 13:39:40 CST 2005 	tskirvin@ks.uiuc.edu
### More checking to make sure we have a proper value.
# 0.52		Fri Mar 18 11:13:39 CST 2005 	tskirvin@ks.uiuc.edu
### Documentation changes.
