#!/usr/local/bin/perl

###
### Software Database initialization/creation script.
###
### Author: John E. Stone <johns@ks.uiuc.edu>
### Theoretical Biophysics Group
### NIH Resource for Macromolecular Modeling and Bioinformatics
### Copyright 2001 Board of Trustees of the University of Illinois
###
### $Id: makedb.pl,v 1.4 2001/01/25 22:24:56 johns Exp $
###

# load database configuration variables
do "dbconfig.pl";

$key_t  = "int not null primary key auto_increment";
$id_t  = "int";
$int_t = "int";
$date_t = "date";
$text_t = "text";

use DBI;

print "Creating new $db database\n";
#system "mysql_setpermission --user root"
system "mysqladmin \--password=$passwd drop $db";
system "mysqladmin \-u $user \--password=$passwd create $db";

print "Connecting to newly created $db DB...\n";
$dbh = DBI->connect("$interface:$type:database=$db;host=$host",
       $user, $passwd, {RaiseError => 1});

print "Creating tables in $db DB...\n";

$dbh->do("CREATE TABLE App (		\
	AppID		 $key_t, 	\
	AppName		 $text_t, 	\
	AppDescription	 $text_t,	\	
	AppHomepageURL   $text_t,	\
	AppDownloadURL   $text_t,	\
	AppDocsURL       $text_t,	\
	AppScreenshotURL $text_t,	\
	AppLastUpdate    $date_t,	\
	CatID		 $id_t   	\
	)" );

$dbh->do("CREATE TABLE Cat (		\
	CatID		$key_t,   	\
	CatName		$text_t,	\
	CatDescription	$text_t,	\	
	CatLastUpdate   $date_t 	\
	)"); 

#$dbh->do("CREATE TABLE AppCat (		\
#	AppCatID	$key_t,		\
#	AppID		$id_t,  	\
#	CatID		$id_t   	\
#	)"); 

$dbh->do("CREATE TABLE Version (	\
	VerID		$key_t, 	\
	VerName		$text_t,	\
	VerReleaseDate	$date_t,	\
	VerLicID	$id_t,		\
	VerLastUpdate   $date_t, 	\
	AppID		$id_t 		\
	)"); 
		

$dbh->do("CREATE TABLE License (	\
	LicID		$key_t, 	\
	LicName		$text_t,	\
	LicText		$text_t,	\
	LicDate		$date_t,	\
	LicLastUpdate   $date_t  	\
	)"); 



$dbh->disconnect;
