#!/usr/local/bin/perl

###  
### Software Database CGI interface
###
### Implements a web based software database using MySQL and Perl DBI.  
### This was written very rapidly, and is very much a work-in-progress.  
###
### Author: John E. Stone <johns@ks.uiuc.edu>
### Theoretical Biophysics Group
### NIH Resource for Macromolecular Modeling and Bioinformatics
### Copyright 2001 Board of Trustees of the University of Illinois
###
### $Id: biosoft.cgi,v 1.19 2001/02/05 15:56:43 johns Exp $
###

# Load database name, user, password, web printable title names, etc.
do "dbconfig.pl";

$thisscripturl = $Request_URI . "biosoft.cgi";
$editscripturl = $Request_URI . "admin/editbiosoft.cgi";

use CGI qw(:standard);
use DBI;

print_page_header();

##
## Get passed in parameters...
##
   $category = param('category');
$application = param('application');
    $version = param('version');
    $license = param('license');
     $sortby = param('sortby');
  $searchfor = param('searchfor');
   $showedit = param('showedit');
 $showrecent = param('showrecent');

##
## Color scheme to use
##
#bgcolor = "#2B5C5C";
$catbgcolor = "#000080";
$appbgcolor = "#008900";
$licbgcolor = "#808900";
$verbgcolor = "#008080";

##
## Table formatting controls
##
$tabformat = 'width="85%" cellpadding=0 cellspacing=0 border=0';
 $tdformat = 'valign=top width="100%"';

print <<HTML;
<html>
<head>
<title>$dbprintedname</title>
<body bgcolor=#ffffff>
HTML


$dbh = DBI->connect("$interface:$type:database=$db;host=$host",
       $user, $passwd, {RaiseError => 1});

if ($showrecent) {
  print_recent_changed_apps($showrecent);
} 
elsif ($searchfor) {
  print_search_results($searchfor);
}
elsif ($version) {
  print h1('Version Index Record');
  print p;
  print_version($version);
}
elsif ($application) {
  print h1('Application Index Record');
  print p;
  print_app($application);
}
elsif ($license) {
  print h1('License Index');
  print p;
  print_license($license);
}
elsif ($category) {
  print h1('Application Index');
  print_sortby($sortby);
  print br;
  print p;
  print_category($category, 0, 1);
  print_category_apps($category, $sortby);
}
else {
  print h1('Category Index');
  print p;
  print_categories($sortby);
}


print_page_footer();

$dbh->disconnect;




##
## Everything below are helper routines.
##
sub collect_variables {
  my $variables = "";
  if ($application) { $variables .= "application=" . $application; }
  if    ($category) { $variables .= "&category=" . $category; }
  if     ($version) { $variables .= "&version=" . $version; }
  if     ($license) { $variables .= "&license=" . $license; }
  if    ($showedit) { $variables .= "&showedit=" . $showedit; }
  if      ($sortby) { $variables .= "&sortby=" . $sortby; }

  return $variables; 
} 

sub submit_url_link {
  my ($url, $values, $linktext) = @_;
  print '<a href="' . $url . '?'. $values . '">' . $linktext . '</a>';
}

sub submit_link {
  my ($values, $linktext) = @_;
  submit_url_link($thisscripturl, $values, $linktext);
}

sub submit_var_link {
  my ($linktext) = @_;
  
  submit_url_link($thisscripturl, collect_variables(), $linktext);
}

sub print_submit_new_application {
  print br;
  print '<a href=appaddrequest.html><b>Submit a new application to the database moderators</b></a>';
}

sub print_sortby { 
  my ($sortby) = @_;
  my $variables = collect_variables();

  print "<b>Sort by [ ";
  if ((!$sortby) || ($sortby eq "name")) {
    print "<font color=#000000>Name</font>";
  } else {
    submit_link("sortby=name" . $variables, "Name");
  }
  print " | ";
  if ((!$sortby) || ($sortby eq "name")) {
    submit_link("sortby=date" . $variables, "Last Update");
  } else { 
    print "<font color=#000000>Last Update</font>";
  }
  print " ]</b>";
}


sub print_categories {
  my ($sortby) = @_;

  my $apps = $dbh->prepare("select AppID from App");
  my $numapps = $apps->execute; 
  my $cats;
  $apps->finish;

  if ((!$sortby) || ($sortby eq "name")) {
    $cats = $dbh->prepare("select CatID, CatName, CatDescription from Cat ORDER by CatName ASC");
  } else {
    $cats = $dbh->prepare("select CatID, CatName, CatDescription from Cat ORDER by CatLastUpdate DESC");
  }
  my $numcats = $cats->execute;

  print "<b>$numapps Applications, $numcats Categories</b><br>";
  print br;
  print_search_fields();
  print_recent_fields();
  print_sortby($sortby);
 
  while (my (@row) = $cats->fetchrow_array) {
    print_category($row[0], 1, 1);
  }

  $cats->finish;

  print_submit_new_application;
}


sub print_category {
  my ($catid, $subcat, $countapps) = @_;

  print p;

  my $cat = $dbh->prepare("select CatName, CatDescription from Cat where CatID=$catid");
  $cat->execute;
  my @row = $cat->fetchrow_array; 

  print '<table ' . $tabformat . '>';
  print '<tr>';
  print '<td ' . $tdformat . ' bgcolor="' . $catbgcolor . '">';
  print '<font size="+0" color="#ffffff"><b>';
  if (!$subcat) {
    print "Category: ";
  }
  print $row[0];
  if ($countapps) {
    my $tmpapp = $dbh->prepare("select AppID from App where CatID=$catid");
    $appcount = $tmpapp->execute;
    $tmpapp->finish; 
    printf "  (%d %s)", $appcount, ($appcount == 1 ? "entry" : "entries");
  }

  print '</b></font>';
  print '</td>';
  print '<tr>';
  print '<td>';  
  print p;
  print $row[1];

  if ($subcat) {
    print br;
    $category=$catid;
    submit_var_link("List Entries");
  }

  if ($showedit) {
    print br;
    $category=$catid;
    my $variables = collect_variables();
    submit_url_link($editscripturl, $variables, "Edit Category");
  }

  print '</td>';
  print '</table>';

  $cat->finish;
}


sub print_app {
  my ($appid) = @_;

  my $app = $dbh->prepare("select AppName, AppDescription, AppHomepageURL, AppDownloadURL, AppDocsURL, AppScreenshotURL, DATE_FORMAT(AppLastUpdate, '%m-%d-%Y'), CatID from App where AppID=$appid");
  $app->execute;
  my @row = $app->fetchrow_array;
  $app->finish;  

  my $cat = $dbh->prepare("select CatName from Cat where CatID=$row[7]");
  $cat->execute;
  my @catrow = $cat->fetchrow_array;
  $cat->finish;
  print '<table ' . $tabformat . '>';
  print '<tr>';
  print '<td ' . $tdformat . ' bgcolor="' . $catbgcolor . '">';
  print '<font size="+0" color="#ffffff"><b>';
  print "Category: ";
  print $catrow[0];
  print '</b></font>';
  print '</td>';
  print '<tr>';
  print '<td>';  
#  print '</table>';
#  print p;
#  print '<table ' . $tabformat . '>';
  print '<tr>';
  print '<td ' . $tdformat . ' bgcolor="' . $appbgcolor . '">';
  print '<font size="+0" color="#ffffff"><b>';
  print $row[0];
  print '</b></font>';
  print '</td>';

  print '<tr>';
  print '<td>'; 
  print '<b><font size="+0">Last Update: </font></b>';
  print $row[6];
  print '<br><br></td>';

  print '<tr>';
  print '<td>'; 
  print '<b><font size="+0">Description:</font></b><br>';
  print $row[1];
  print '<br><br></td>';

  if ($row[2]) {
    print '<tr>';
    print '<td>'; 
    print '<b><font size="+0">Homepage:</font></b><br>';
    print '<a href="' . $row[2] . '">' . $row[2] . '</a>';
    print '<br><br></td>';
  }

  if ($row[3]) {
    print '<tr>';
    print '<td>'; 
    print '<b><font size="+0">Download Page:</font></b><br>';
    print '<a href="' . $row[3] . '">' . $row[3] . '</a>';
    print '<br><br></td>';
  }

  if ($row[4]) {
    print '<tr>';
    print '<td>'; 
    print '<b><font size="+0">Documentation Page:</font></b><br>';
    print '<a href="' . $row[4] . '">' . $row[4] . '</a>';
    print '<br><br></td>';
  }

  if ($row[5]) {
    print '<tr>';
    print '<td>'; 
    print '<b><font size="+0">Screenshots Page:</font></b><br>';
    print '<a href="' . $row[5] . '">' . $row[5] . '</a>';
    print '<br><br></td>';
  }

  my $ver = $dbh->prepare("select VerID, VerName, DATE_FORMAT(VerReleaseDate, '%m-%d-%Y'), VerLicID from Version where AppID=$appid");
  $numversions = $ver->execute;

  if ($numversions > 0) { 
    print '<tr>';
    print '<td>'; 
    print '<b><font size="+1">Version History:</font></b>';
    while (my (@vrow) = $ver->fetchrow_array) {
      print br;
      $version=$vrow[0];
      submit_var_link("Version: " . $vrow[1]);
      print br;

      print "Release Date: " . $vrow[2] . " <br>"; 

    }

    print '</td>';
  }
  else { 
    print '<tr>';
    print '<td>'; 
##
## When we do more with versions, add this back in.
## 
##   print '<b><font size="+0">No Version Information Available.</font></b>';
  }
  $ver->finish;  

  print '</table>';
}



sub print_version {
  my ($verid) = @_;

  my $ver = $dbh->prepare("select VerName, DATE_FORMAT(VerReleaseDate, '%m-%d-%Y'), VerLicID, DATE_FORMAT(VerLastUpdate, '%m-%d-%Y'), AppID from Version where VerID=$verid");
  $ver->execute; 
  my @row = $ver->fetchrow_array;

  $app=$dbh->prepare("select AppName from App where AppID=$row[4]");
  $app->execute;
  @appname=$app->fetchrow_array;
  $app->finish;

  print p;
  print '<table ' . $tabformat . '>';
  print '<tr>';
  print '<td ' . $tdformat . ' bgcolor="' . $verbgcolor . '">';
  print '<font size="+0" color="#ffffff"><b>';
  print $appname[0] . " " . $row[0];
  print '</b></font>';
  print '</td>';
  print '<tr>';
  print '<td>';
  print '<b>Last Update: </b>' . $row[3] . '<br>'; 
  print '<b>Version Release Date: </b>' . $row[1] . '<br>'; 

  $lic = $dbh->prepare("select LicName from License where LicID=$row[2]");
  $lic->execute;
  @licname = $lic->fetchrow_array;
  $lic->finish;
 
  print "<b>License: </b>";
  $license=$row[2];
  submit_var_link($licname[0]);
  print br;

  print "<p>Lots and lots of other version specific information could go here.  Anything ranging from version specific changelogs, version specific doc URLs, lots and lots of stuff could be added to version to make them more helpful";

  print '</table>';



  $ver->finish;
}



sub print_license {
  my ($licid) = @_;
  
  my $lic = $dbh->prepare("select LicName, LicText, LicDate, LicLastUpdate from License where LicID=$licid");
  $lic->execute;
  my @row = $lic->fetchrow_array;

  print p;
  print '<table ' . $tabformat . '>';
  print '<tr>';
  print '<td ' . $tdformat . ' bgcolor="' . $licbgcolor . '">';
  print '<font size="+0" color="#ffffff"><b>';
  print $row[0];
  print '</b></font>';
  print '</td>';
  print '<tr>';
  print '<td>';
  print '<b>Last Update: </b>' . $row[3] . '<br>'; 
  print '<b>License Release Date: </b>' . $row[2] . '<br>'; 
  print '<b>License Text: </b>';
  print $row[1];

  print '</td>';
  print '</table>';
 
  $lic->finish;
}


sub print_app_cat {
  my ($appid) = @_;

  my $app = $dbh->prepare("select AppName, AppDescription from App where AppID=$appid");
  $app->execute;

  my @row = $app->fetchrow_array;

  print p;
  print '<table ' . $tabformat . '>';
  print '<tr>';
  print '<td ' . $tdformat . ' bgcolor="' . $appbgcolor . '">';
  print '<font size="+0" color="#ffffff"><b>';
  print $row[0];
  print '</b></font>';
  print '</td>';
  print '<tr>';
  print '<td>'; 
  print p;
  print $row[1];

  print br;
  $application=$appid;
  submit_var_link("View Application Entry for " . $row[0]);

  if ($showedit) {
    print br;
    submit_url_link($editscripturl, "application=" . $appid, "Edit Application");
  }

  print '</td>';
  print '</table>';

  $app->finish;
}


sub print_category_apps { 
  my ($catid, $sortby) = @_;
  my $apps;

  if ((!$sortby) || ($sortby eq "name")) {
    $apps = $dbh->prepare("select AppID, AppName, AppDescription from App where CatID=$catid ORDER by AppName ASC");
  } else {
    $apps = $dbh->prepare("select AppID, AppName, AppDescription from App where CatID=$catid ORDER by AppLastUpdate DESC");
  }

  $apps->execute;
  while (my (@arow) = $apps->fetchrow_array) {
    print_app_cat($arow[0]); 
  }

  $apps->finish;

  print_submit_new_application;
}


sub print_search_fields {
  print start_form;
  print "<b>Search: </b>" . 
        "use % characters for wildcard searches";
  print br;
  print textfield(-name=>"searchfor", -default=>"search%text", -size=>40);
  print submit(value=>'submit');
  print end_form;
}


sub print_search_results {
  my ($appdescription) = @_;

  print "<p><b>Search text: </b>";
  print $searchfor;
  print p;

  my $liketest = "%" . $appdescription . "%";

  my $app = $dbh->prepare("select AppName, AppDescription, AppHomepageURL, AppDownloadURL, AppDocsURL, AppScreenshotURL, DATE_FORMAT(AppLastUpdate, '%m-%d-%Y'), AppID from App where AppDescription LIKE '$liketest'");
  $nummatches = $app->execute;

  printf "Found %d matches to query.", $nummatches;

  if ($nummatches < 1) {
    return;
  }

  while (my @row = $app->fetchrow_array) {
    my $appid = $row[7];

    print p;
    print '<table ' . $tabformat . '>';
    print '<tr>';
    print '<td ' . $tdformat . ' bgcolor="' . $appbgcolor . '">';
    print '<font size="+0" color="#ffffff"><b>';
    print $row[0];
    print '</b></font>';
    print '</td>';

    print '<tr>';
    print '<td>';
    print '<b><font size="+0">Last Update: </font></b>';
    print $row[6];
    print '<br><br></td>';

    print '<tr>';
    print '<td>';
    print '<b><font size="+0">Description:</font></b><br>';
    print $row[1];
    print br;

    $application=$appid;
    submit_var_link("View Application Entry");
    print '<br><br></td>';
    print '</table>';
  }

  $app->finish;
}

sub print_recent_fields {
  print start_form;
  print "</b>Display "; 
  print textfield(-name=>"showrecent", -default=>"25", -size=>3);
  print " most recently updated application entries.";
  print submit(value=>'submit');
  print end_form;
}

sub print_recent_changed_apps {
  my ($maxshown) = @_;
  my $shown=1;

  print p;
  $apps = $dbh->prepare("select AppID, AppName, AppDescription, AppLastUpdate from App ORDER by AppLastUpdate DESC");
  $numapps = $apps->execute;
  print strong("Number of Application Entries: $numapps<br>");
  print strong("Maximum shown: $maxshown<br>");

  print br;
  while ((my (@row) = $apps->fetchrow_array) && ($shown <= $maxshown) ) {
    print p;
    print '<table ' . $tabformat . '>';
    print '<tr>';
    print '<td ' . $tdformat . ' bgcolor="' . $appbgcolor . '">';
    print '<font size="+0" color="#ffffff"><b>';
    print $row[1];
    print '</b></font>';
    print '</td>';

    print '<tr>';
    print '<td>';
    print '<b><font size="+0">Last Update: </font></b>';
    print $row[3];
    print '<br><br></td>';

    print '<tr>';
    print '<td>';
    print '<b><font size="+0">Description:</font></b><br>';
    print $row[2];
    print br;

    $appid=$row[0];
    $application=$appid;
    submit_var_link("View Application Entry");
    print '<br><br></td>';
    print '</table>';

    $shown=$shown + 1;
  }
  $apps->finish;
}  




