#!/usr/local/bin/perl

###  
### Software Database CGI interface
###
### Implements a web based software database akin to 
### freshmeat using MySQL.
###
### $Id: editbiosoft.cgi,v 1.10 2001/02/05 15:57:22 johns Exp $
###

# Load database name, user, password, web printable title names, etc.
do "../dbconfig.pl";

$thisscripturl = $Request_URI . "editbiosoft.cgi";
$mainscripturl = $Request_URI . "../biosoft.cgi";

use CGI qw(:standard);
use DBI;

print_page_header();

##
## Get passed in parameters...
##
   $category = param('category');
$application = param('application');
    $version = param('version');
    $license = param('license');
     $sortby = param('sortby');

     $save_edit = param('save_edit');
 $save_edit_new = param('save_edit_new');


##
## Color scheme to use
##
#bgcolor = "#2B5C5C";
$catbgcolor = "#000080";
$appbgcolor = "#008900";
$licbgcolor = "#808900";
$verbgcolor = "#008080";

##
## Table formatting controls
##
$tabformat = 'width="85%" cellpadding=0 cellspacing=0 border=0';
 $tdformat = 'valign=top width="100%"';

print <<HTML;
<html>
<head>
<title>$dbprintedname</title>
<body bgcolor=#ffffff>
HTML


$dbh = DBI->connect("$interface:$type:database=$db;host=$host",
       $user, $passwd, {RaiseError => 1});

  print h1($dbprintedname . ' Editor');
  print p;

  if ($application) { 
    if ($save_edit || $save_edit_new) {
      save_application();
    } else {
      edit_application($application);
    } 
  } elsif ($category) {
    if ($save_edit || $save_edit_new) {
      save_category();
    } else {
      edit_category($category);
    } 
  }
  else {
    submit_url_link($mainscripturl, "showedit=true", "Edit Database Entries");
  }

print_page_footer();

$dbh->disconnect;



##
## Everything below are helper routines.
##

sub submit_url_link {
  my ($url, $values, $linktext) = @_;
  print '<a href="' . $url . '?'. $values . '">' . $linktext . '</a>';
}

sub submit_link {
  my ($values, $linktext) = @_;
  submit_url_link($thisscripturl, $values, $linktext);
}


##
## Application editing
##

sub edit_application {
  my ($appid) = @_;

  my $app = $dbh->prepare("select AppName, AppDescription, AppHomePageURL, AppDownloadURL, AppDocsURL, AppScreenshotURL, AppLastUpdate, CatID from App where AppID=$appid");
  $app->execute;
  my @row = $app->fetchrow_array;

  print p;

  print start_form;
  print hidden('appid', $appid);
  print hidden('application', $appid);

  print "<b>Name of Application: </b><br>";
  print textfield(-name=>"appname", -default=>$row[0], -size=>80);
  print br;
  print "<b>Application Description: </b><br>";
  print textarea(-name=>"appdescription", -default=>$row[1], -rows=>16, -columns=>80);
  print br;


  print "<b>Homepage URL: </b> (optional)<br>";
  print textfield(-name=>"apphomepageurl", -default=>$row[2], -size=>80);
  print br;
  print "<b>Download URL: </b> (optional)<br>";
  print textfield(-name=>"appdownloadurl", -default=>$row[3], -size=>80);
  print br;
  print "<b>Documentation URL: </b> (optional)<br>";
  print textfield(-name=>"appdocsurl", -default=>$row[4], -size=>80);
  print br;
  print "<b>Screenshots URL: </b> (optional)<br>";
  print textfield(-name=>"appscreenshoturl", -default=>$row[5], -size=>80);
  print br;

  print "<b>Category:</b><br>";
 
  my $cat = $dbh->prepare("select CatName, CatID from Cat");
  my $numcats = $cat->execute; 
  my %menuhash;
  while (my (@row) = $cat->fetchrow_array) {
    $menuhash{$row[1]} = $row[0]; 
  }
  $cat->finish;
  print popup_menu(-name=>'catid',-values=>\%menuhash, -default=>$row[7]);

  print p;
  print "<b>Save Changes:</b><br>";
  print submit(-name=>'save_edit', -value=>'Save');
  print submit(-name=>'save_edit_new', -value=>'Save as new application');

  print end_form;

  $app->finish;
}


sub save_application {
  print p;
  $appid = param('appid');
  $appname = param('appname');
  $appdescription = param('appdescription');
  $apphomepageurl = param('apphomepageurl');
  $appdownloadurl = param('appdownloadurl');
  $appdocsurl = param('appdocsurl');
  $appscreenshoturl = param('appscreenshoturl');
  $catid = param('catid');

  if ($save_edit_new) {
    add_new_application($appname, $appdescription, $apphomepageurl, $appdownloadurl, $appdocsurl, $appscreenshoturl, $catid);
  }
  else {
    update_application($appid, $appname, $appdescription, $apphomepageurl, $appdownloadurl, $appdocsurl, $appscreenshoturl, $catid);
  }
}


sub update_application { 
  my ($appid, $name, $desc, $hpurl, $dlurl, $dcurl, $ssurl, $catid) = @_;
  my $app = $dbh->prepare("UPDATE App SET AppName='$name', AppDescription='$desc', AppHomepageURL='$hpurl', AppDownloadURL='$dlurl', AppDocsURL='$dcurl', AppScreenshotURL='$ssurl', AppLastUpdate=FROM_UNIXTIME(UNIX_TIMESTAMP()), CatID='$catid' where AppID=$appid"); 
  $app->execute;

  print p;
  print "<h1>Updated Application " . $name . "</h1>";
}

sub add_new_application { 
  my ($name, $desc, $hpurl, $dlurl, $dcurl, $ssurl, $catid) = @_;
  my $app = $dbh->prepare("INSERT INTO App ( AppName, AppDescription, AppHomepageURL, AppDownloadURL, AppDocsURL, AppScreenshotURL, AppLastUpdate, CatID ) \
        VALUES ( '$name', '$desc', '$hpurl', '$dlurl', '$dcurl', '$ssurl', FROM_UNIXTIME(UNIX_TIMESTAMP()), $catid )");
  $app->execute;

  print p;
  print "<h1>Added Application " . $name . "</h1>";
}


##
## Category editing
##

sub edit_category {
  my ($catid) = @_;

  my $cat = $dbh->prepare("select CatName, CatDescription, CatLastUpdate from Cat where CatID=$catid");
  $cat->execute;
  my @row = $cat->fetchrow_array;

  print p;

  print start_form;
  print hidden('catid', $catid);
  print hidden('category', $catid);

  print "<b>Name of Category: </b><br>";
  print textfield(-name=>"catname", -default=>$row[0], -size=>80);
  print br;
  print "<b>Category Description: </b><br>";
  print textarea(-name=>"catdescription", -default=>$row[1], -rows=>16, -columns=>80);
  print br;

  print p;
  print "<b>Save Changes:</b><br>";
  print submit(-name=>'save_edit', -value=>'Save');
  print submit(-name=>'save_edit_new', -value=>'Save as new category');

  print end_form;

  $cat->finish;
}

sub save_category {
  print p;
  $catid = param('catid');
  $catname = param('catname');
  $catdescription = param('catdescription');

  if ($save_edit_new) {
    add_new_category($catname, $catdescription);
  }
  else {
    update_category($catid, $catname, $catdescription);
  }
}

sub update_category {
  my ($catid, $name, $desc) = @_;
  my $cat = $dbh->prepare("UPDATE Cat SET CatName='$name', CatDescription='$desc', CatLastUpdate=FROM_UNIXTIME(UNIX_TIMESTAMP()) where CatID=$catid");
  $cat->execute;
  $cat->finish;

  print p;
  print "<h1>Updated Category " . $name . "</h1>";
}

sub add_new_category {
  my ($name, $desc) = @_;
  my $cat = $dbh->prepare("INSERT INTO Cat ( CatName, CatDescription, CatLastUpdate ) \
	VALUES ( '$name', '$desc', FROM_UNIXTIME(UNIX_TIMESTAMP()))");
  $cat->execute;
  $cat->finish;
  print p;
  print "<h1>Added Category " . $name . "</h1>";
}


