#!/usr/local/bin/perl

#use vars qw(host db user passwd type interface debug);
$host      = "localhost";
$db        = foobartest;
$user      = "dbuser";
$passwd    = "dbpassword";
$type      = mysql;
$interface = DBI;
$debug     = 0;


use DBI;

sub get_lastid {
  $lastid=$dbh->prepare("SELECT LAST_INSERT_ID()");
  $lastid->execute;
  my (@row) = $lastid->fetchrow_array;
  $foo=$row[0];
  $lastid->finish;

  return $foo;
}

sub add_cat {
  my ($name, $desc) = @_;
  my $cat = $dbh->prepare("INSERT INTO Cat ( CatName, CatDescription, CatLastUpdate ) \
	VALUES ( '$name', '$desc', FROM_UNIXTIME(UNIX_TIMESTAMP()))");
  $cat->execute;
}

sub add_app { 
  my ($name, $desc, $hpurl, $dlurl, $dcurl, $ssurl, $catid) = @_;
  print "Adding App: " . $name . "\n";
  my $app = $dbh->prepare("INSERT INTO App ( AppName, AppDescription, AppHomepageURL, AppDownloadURL, AppDocsURL, AppScreenshotURL, AppLastUpdate, CatID ) \
	VALUES ( '$name', '$desc', '$hpurl', '$dlurl', '$dcurl', '$ssurl', FROM_UNIXTIME(UNIX_TIMESTAMP()), $catid )");
  $app->execute;
}


sub add_license {
  my ($name, $text, $licdate) = @_;
  my $lic = $dbh->prepare("INSERT INTO License ( LicName, LicText, LicDate, LicLastUpdate ) \
	VALUES ( '$name', '$text', '$licdate', FROM_UNIXTIME(UNIX_TIMESTAMP()))"); 
  $lic->execute;
}

sub add_version { 
  my ($name, $appid, $licid, $verdate) = @_;
  my $ver = $dbh->prepare("INSERT INTO Version ( VerName, AppID, VerLicID, VerReleaseDate, VerLastUpdate ) \
	VALUES ( '$name', $appid, $licid, '$verdate', FROM_UNIXTIME(UNIX_TIMESTAMP()))");
  $ver->execute;
}

print "Connecting to $db DB...\n";
$dbh = DBI->connect("$interface:$type:database=$db;host=$host",
       $user, $passwd, {RaiseError => 1});

print "Connected to $db DB...\n";

print "Adding some bogus records\n";


##
## Add some licenses
##

add_license("Unknown", "Not known at this time.", "0000-00-00");
$UKid = get_lastid();
add_license("Public Domain", "No restrictions of any kind.", "0000-00-00");
$PDid = get_lastid();
add_license("GPL", "See http://www.gnu.org/", "0000-00-00");  
$GPLid = get_lastid();
add_license("LGPL", "See http://www.gnu.org/", "0000-00-00");  
add_license("VMD", "See http://www.ks.uiuc.edu/Research/vmd/LICENSE.html", "2000-01-01");  
$VMDlicid = get_lastid();
add_license("NAMD", "See http://www.ks.uiuc.edu/Research/namd2/", "2000-01-01");
$NAMDlicid = get_lastid();


##
## Add some categories
##

##
## Vis programs
##
add_cat("Molecular Visualization", 
"This section has a collection of software specialized in molecular 
 visualization. 
 Most of them are for rendering large biomolecule s such as proteins 
 and DNA/RNA from a wide variety of file formats. Some of them
 are capable of displaying the molecular orbitals or the electron
 densty resulted from Ab Initio calculations. Some can be used with a web 
 browser as a plug-in. ");
$catid = get_lastid();

add_app("VMD", "VMD is a molecular visualization program for displaying, 
animating, and analyzing large biomolecular systems using 3-D graphics 
and built-in scripting. VMD supports computers running Unix or Windows, 
is distributed free of charge, and includes source code.", 
"http://www.ks.uiuc.edu/Research/vmd", 
"http://www.ks.uiuc.edu/Development/Download/download.cgi", 
"http://www.ks.uiuc.edu/Research/vmd/current/docs.html",
"http://www.ks.uiuc.edu/Research/vmd/vmd-1.6/screenshots/",
$catid);
$VMDid = get_lastid();

add_version("1.6a3", $VMDid, $VMDlicid, "2000-10-06");
add_version("1.5"  , $VMDid, $VMDlicid, "2000-06-28");
add_version("1.4"  , $VMDid, $VMDlicid, "2000-01-07");
add_version("1.3"  , $VMDid, $VMDlicid, "1999-04-05");
add_version("1.2"  , $VMDid, $VMDlicid, "1999-08-01");
add_version("1.1"  , $VMDid, $VMDlicid, "1996-05-15");
add_version("1.0"  , $VMDid, $VMDlicid, "1995-07-01");


add_app("RasMol", "RasMol is a free program which displays molecular structure.
It is available for on PC/Windows (RasWin), MacIntosh (RasMac), unix, and 
VAX VMS (the latter two via X-windows), and also (through ports by users) 
for NEXTSTEP and for Acorn Archimedes RISC OS. RasMol is a powerful 
educational tool for showing the structure of DNA, proteins and smaller 
molecules. It is also a powerful res earch tool. It is easy to use 
and produces beautiful, space-filling, colored, 3-dimensional images.", 
"http://www.bernstein-plus-sons.com/software/rasmol/", 
"http://www.bernstein-plus-sons.com/software/rasmol/#CodeAndBinaries",
"",
"",
$catid);

add_app("MolMol", "MOLMOL is a molecular graphics program for displaying, 
analyzing, and manipulating the three-dimensional structure of biological 
macromolecules, with special emphasis on the study of protein or DNA 
structures determined by NMR. The program runs on UNIX and Windows 
NT/95/98/2000 and is freely available.", 
"http://www.mol.biol.ethz.ch/wuthrich/software/molmol/",
"",
"",
"",
$catid);


##
## MD programs
##
add_cat("Molecular Dynamics", "Programs or software systems for performing molecular dynamics simulations.");
$catid = get_lastid();

add_app("NAMD", " NAMD is a parallel, object-oriented molecular dynamics code designed for high-performance simulation of large biomolecular systems. NAMD is distributed free of charge and includes source code.", 
"http://www.ks.uiuc.edu/Research/namd/",
"http://www.ks.uiuc.edu/Development/Download/download.cgi",
"",
"",
$catid);

add_app("NAMD2", "NAMD2 is a parallel, object-oriented molecular dynamics code designed for high-performance simulation of large biomolecular systems. NAMD is distributed free of charge and includes source code.", 
"http://www.ks.uiuc.edu/Research/namd/",
"http://www.ks.uiuc.edu/Development/Download/download.cgi",
"",
"",
$catid);
$NAMDid = get_lastid();

add_version("2.1", $NAMDid, $NAMDlicid, "2000-01-01");
add_version("2.2", $NAMDid, $NAMDlicid, "2000-01-01");


add_cat("Molecular Building", "The software in this section is particularly for constructing molecules from small organic/ inorganic molecules to macromolecules like proteins DNA/RNA and polymers.");

add_cat("Gene and Protein Sequence Alignment and Phylogenetic Search",
"Some software (e.g. CLUSTAL W, GCG) in this section is specific for doing the sequence alignment of proteins and DNA. Others(e.g. GCG, PHYLIP) are for searching for the evolutionary relationship between of gene (or protein) sequence from an organism and that from other organisms.");

add_cat("Protein Structure Analysis and Verification", 
"This is a collection of analysis tools for protein such as 3-D structure comparison, binding site identification, noncovalent bond finder  etc.");

add_cat("Molecular Dynamics Force Fields", 
"This is a collections of the popular force fields used in molecular dynamics simulation e.g. CHARMm and AMBER."); 

add_cat("Molecular Docking", "Software in this section are particularly for docking a small molecule like drug or ligand onto a large molecule such as an enzyme.");

add_cat("Quantum Chemistry Calculation", "This is a set of computers programs specialized in quantum mechanical calculation.");

add_cat("Biological Collaboration", "The computer programs in this section are web-based tools that integrates molecular dynamics simulation and visualisation onto the internet for long distance collaboration in structural biology research.");

add_cat("Molecular File Format Conversion", "Programs to convert data files from one format to another");


add_cat("Miscellaneous", "Programs which do not fit into other categories");
$catid = get_lastid();
add_app("Mathematica", "yet another cool program", 
"http://www.mathemetica.com/",
"",
"",
"",
$catid);

$dbh->disconnect;
