/*
 *  serial.h -- Machine/OS dependent serial I/O code for LibOrb
 *
 *  Copyright 1997 John E. Stone (j.stone@acm.org)
 *                               (johns@megapixel.com)
 *
 *  $Id: serial.h,v 1.1 2001/04/11 00:04:25 johns Exp $
 *
 */

/*
 * Machine/OS dependent serial port I/O routines.
 *
 * serial_comm_open() - open the serial port device for communication.
 *                      Settings are 9600,N,8,1, non-blocking,
 *                      no controlling tty.
 * serial_comm_read() - nonblocking read of up to size bytes
 * serial_comm_write() - blocking write of up to size bytes
 * serial_comm_close() - close the serial port device
 */

typedef void * SerialCommHandle;

int serial_comm_open(char * commname, SerialCommHandle * commhandleptr); 
int serial_comm_write(SerialCommHandle commhandle, char * buf, int len); 
int serial_comm_read(SerialCommHandle commhandle, char * buf, int sz); 
int serial_comm_close(SerialCommHandle * commhandleptr); 

