/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * timer.h
 *
 * Used for gathering timing statistics
 */

#ifndef TIMER_H
#define TIMER_H

#if defined(MDX_LINUX)
#include <sys/time.h>
#include <unistd.h>
#elif defined(MDX_SUN)
#include <time.h>
#else
#include <sys/time.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

  /*
   * accumulate total time in seconds, while returning time "deltas"
   * each time you click the stopwatch
   */
  typedef struct Timer_t {
    double total;          /* accumulates total time */
    double delta;          /* difference between most recent clicks */
    struct timeval tv;     /* stores an earlier time value */
    char msg[64];          /* pretty-print the time for nice output */
  } Timer;

  /* construct/destruct a timer object on the heap */
  Timer *timer_create(void);
  void timer_destroy(Timer *);

  /* init/cleanup an allocated timer object */
  int timer_initialize(Timer *);
  void timer_cleanup(Timer *);

  /* click the stopwatch to receive a "delta" since the last click */
  double timer_click(Timer *);

  /* return total time so far, sum of all previous time deltas */
  double timer_total(Timer *);

  /* pretty-print most recent timer delta */
  const char *timer_msg_delta(Timer *);

  /* pretty-print total time */
  const char *timer_msg_total(Timer *);

#ifdef __cplusplus
}
#endif

#endif /* TIMER_H */
