/*
 * step_error.c
 */

#include <stdarg.h>
#include <stdio.h>
#include "step/step_defn.h"


/* populate errmsg string buffer with error message for library caller */
int step_error(Step *s, const char *fmt, ...)
{
  va_list ap;

  va_start(ap, fmt);
  vsnprintf(s->errmsg, sizeof(s->errmsg), fmt, ap);
  va_end(ap);

  return STEP_FAILURE;
}
