/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * split.h
 */

#ifndef SPLIT_H
#define SPLIT_H

#include <math.h>
#include "mgrid/mgrid.h"

#ifdef __cplusplus
extern "C" {
#endif


  /* constants for ERRMIN3 splitting */
#if 0
#define  MGRID_ERRMIN3_A  (-0.04465110103718)
#define  MGRID_ERRMIN3_B  (0.50895330311154)
#define  MGRID_ERRMIN3_C  (-1.38395330311154)
#define  MGRID_ERRMIN3_D  (1.91965110103718)
#endif
#define  MGRID_ERRMIN3_A  (-1./16)
#define  MGRID_ERRMIN3_B  (9./16)
#define  MGRID_ERRMIN3_C  (-23./16)
#define  MGRID_ERRMIN3_D  (31./16)

  /* constants for EXCLSW1 splitting */
#define  MGRID_EXSELF1_swdis  (1./2)
#define  MGRID_EXSELF1_A  (1./4)
#define  MGRID_EXSELF1_B  (-3./8)
#define  MGRID_EXSELF1_C  (-1./2)
#define  MGRID_EXSELF1_D  (13./8)
#define  MGRID_EXSELF1_E  (-11./16)
#define  MGRID_EXSELF1_F  (53./32)

#define  MGRID_EXSELF2_swdis  (1./3)
#define  MGRID_EXSELF2_A  (3./16)
#define  MGRID_EXSELF2_B  (-3./16)
#define  MGRID_EXSELF2_C  (-11./16)
#define  MGRID_EXSELF2_D  (27./16)
#define  MGRID_EXSELF2_E  (-3./4)
#define  MGRID_EXSELF2_F  (61./36)

#define  MGRID_EXSELF3_swdis  (1./4)
#define  MGRID_EXSELF3_A  (1./6)
#define  MGRID_EXSELF3_B  (-1./8)
#define  MGRID_EXSELF3_C  (-3./4)
#define  MGRID_EXSELF3_D  (41./24)
#define  MGRID_EXSELF3_E  (-25./32)
#define  MGRID_EXSELF3_F  (219./128)

#define  MGRID_EXSELF7_swdis  (0.5)
#define  MGRID_EXSELF7_A  (8./13)
#define  MGRID_EXSELF7_B  (-24./13)
#define  MGRID_EXSELF7_C  (24./13)
#define  MGRID_EXSELF7_D  (5./13)
#define  MGRID_EXSELF7_E  (20./13)
#define  MGRID_EXSELF7_F  (-36./13)
#define  MGRID_EXSELF7_G  (12./13)
#define  MGRID_EXSELF7_H  (-5./26)
#define  MGRID_EXSELF7_I  (-0.652713951864506)
#define  MGRID_EXSELF7_J  (1.63178487966126)

  /* switching for exact self-force using odd powers of r */

#define  MGRID_EXSFPC2_swdis  (7./8)
#define  MGRID_EXSFPC2_A  (649./3)
#define  MGRID_EXSFPC2_B  (-931)
#define  MGRID_EXSFPC2_C  (1505)
#define  MGRID_EXSFPC2_D  (-3232./3)
#define  MGRID_EXSFPC2_E  (288)
#define  MGRID_EXSFPC2_F  (409./384)

#define  MGRID_EXSFPQ2_swdis  (7./8)
#define  MGRID_EXSFPQ2_A  (-19./15)
#define  MGRID_EXSFPQ2_B  (49./5)
#define  MGRID_EXSFPQ2_C  (-59./5)
#define  MGRID_EXSFPQ2_D  (64./15)
#define  MGRID_EXSFPQ2_E  (191./120)
#define  MGRID_EXSFPQ2_F  (-3./5)

#define  MGRID_EXSFRC2_swdis  (7./8)
#define  MGRID_EXSFRC2_A  (1029./5)
#define  MGRID_EXSFRC2_B  (-13312./15)
#define  MGRID_EXSFRC2_C  (7168./5)
#define  MGRID_EXSFRC2_D  (-1024)
#define  MGRID_EXSFRC2_E  (4096./15)
#define  MGRID_EXSFRC2_F  (16./15)

#define  MGRID_EXSFRQ2_swdis  (7./8)
#define  MGRID_EXSFRQ2_A  (-49./15)
#define  MGRID_EXSFRQ2_B  (64./5)
#define  MGRID_EXSFRQ2_C  (-64./5)
#define  MGRID_EXSFRQ2_D  (64./15)
#define  MGRID_EXSFRQ2_E  (8./5)
#define  MGRID_EXSFRQ2_F  (-64./105)


#ifdef MGRID_FAST_SPLIT

  /* define macros for inlined splitting function evaluation */

#define gamma(pg, s, split)                                                    \
  do {                                                                         \
    /* double _s = (r_a * r_a); */                                             \
    double _s = s;                                                             \
    double _g = 0;                                                             \
    switch (split) {                                                           \
      case MGRID_TAYLOR1:                                                      \
        _g = 1 + (_s-1)*(-1./2);                                               \
        break;                                                                 \
      case MGRID_TAYLOR2:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8));                               \
        break;                                                                 \
      case MGRID_TAYLOR3:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16)));             \
        break;                                                                 \
      case MGRID_TAYLOR4:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128))));                                         \
        break;                                                                 \
      case MGRID_TAYLOR5:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256)))));                     \
        break;                                                                 \
      case MGRID_TAYLOR6:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024))))));                                 \
        break;                                                                 \
      case MGRID_TAYLOR7:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048)))))));           \
        break;                                                                 \
      case MGRID_TAYLOR8:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048                   \
                        + (_s-1)*(6435./32768))))))));                         \
        break;                                                                 \
      case MGRID_ERRMIN3:                                                      \
        _g = MGRID_ERRMIN3_D + _s*(MGRID_ERRMIN3_C + _s*(MGRID_ERRMIN3_B       \
              + _s*MGRID_ERRMIN3_A));                                          \
        break;                                                                 \
      case MGRID_EXSELF1:                                                      \
        if (_s > MGRID_EXSELF1_swdis) {                                        \
          _g = MGRID_EXSELF1_D + _s*(MGRID_EXSELF1_C + _s*(MGRID_EXSELF1_B     \
                + _s*MGRID_EXSELF1_A));                                        \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF1_F + _s*MGRID_EXSELF1_E;                           \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF2:                                                      \
        if (_s > MGRID_EXSELF2_swdis) {                                        \
          _g = MGRID_EXSELF2_D + _s*(MGRID_EXSELF2_C + _s*(MGRID_EXSELF2_B     \
                + _s*MGRID_EXSELF2_A));                                        \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF2_F + _s*MGRID_EXSELF2_E;                           \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF3:                                                      \
        if (_s > MGRID_EXSELF3_swdis) {                                        \
          _g = MGRID_EXSELF3_D + _s*(MGRID_EXSELF3_C + _s*(MGRID_EXSELF3_B     \
                + _s*MGRID_EXSELF3_A));                                        \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF3_F + _s*MGRID_EXSELF3_E;                           \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF7:                                                      \
        if (_s > MGRID_EXSELF7_swdis) {                                        \
          _g = (MGRID_EXSELF7_D + _s*(MGRID_EXSELF7_C + _s*(MGRID_EXSELF7_B    \
                + _s*MGRID_EXSELF7_A))) / sqrt(_s);                            \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF7_J + _s*MGRID_EXSELF7_I;                           \
        }                                                                      \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
  } while (0)


#define dgamma(pg, pdg, s, split)                                              \
  do {                                                                         \
    /* double _s = (r_a * r_a); */                                             \
    double _s = s;                                                             \
    double _g = 0, _dg = 0;                                                    \
    switch (split) {                                                           \
      case MGRID_TAYLOR1:                                                      \
        _g = 1 + (_s-1)*(-1./2);                                               \
        _dg = -1./2;                                                           \
        break;                                                                 \
      case MGRID_TAYLOR2:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8));                               \
        _dg = -1./2 + (_s-1)*(3./4);                                           \
        break;                                                                 \
      case MGRID_TAYLOR3:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16)));             \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16));                        \
        break;                                                                 \
      case MGRID_TAYLOR4:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128))));                                         \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32)));      \
        break;                                                                 \
      case MGRID_TAYLOR5:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256)))));                     \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256))));                                       \
        break;                                                                 \
      case MGRID_TAYLOR6:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024))))));                                 \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256 + (_s-1)*(693./512)))));                   \
        break;                                                                 \
      case MGRID_TAYLOR7:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048)))))));           \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256 + (_s-1)*(693./512                         \
                    + (_s-1)*(-3003./2048))))));                               \
        break;                                                                 \
      case MGRID_TAYLOR8:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048                   \
                        + (_s-1)*(6435./32768))))))));                         \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256 + (_s-1)*(693./512                         \
                    + (_s-1)*(-3003./2048 + (_s-1)*(6435./4096)))))));         \
        break;                                                                 \
      case MGRID_ERRMIN3:                                                      \
        _g = MGRID_ERRMIN3_D + _s*(MGRID_ERRMIN3_C + _s*(MGRID_ERRMIN3_B       \
              + _s*MGRID_ERRMIN3_A));                                          \
        _dg = MGRID_ERRMIN3_C + _s*(2*MGRID_ERRMIN3_B + _s*3*MGRID_ERRMIN3_A); \
        break;                                                                 \
      case MGRID_EXSELF1:                                                      \
        if (_s > MGRID_EXSELF1_swdis) {                                        \
          _g = MGRID_EXSELF1_D + _s*(MGRID_EXSELF1_C + _s*(MGRID_EXSELF1_B     \
                + _s*MGRID_EXSELF1_A));                                        \
          _dg = MGRID_EXSELF1_C + _s*(2*MGRID_EXSELF1_B                        \
              + _s*3*MGRID_EXSELF1_A);                                         \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF1_F + _s*MGRID_EXSELF1_E;                           \
          _dg = MGRID_EXSELF1_E;                                               \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF2:                                                      \
        if (_s > MGRID_EXSELF2_swdis) {                                        \
          _g = MGRID_EXSELF2_D + _s*(MGRID_EXSELF2_C + _s*(MGRID_EXSELF2_B     \
                + _s*MGRID_EXSELF2_A));                                        \
          _dg = MGRID_EXSELF2_C + _s*(2*MGRID_EXSELF2_B                        \
              + _s*3*MGRID_EXSELF2_A);                                         \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF2_F + _s*MGRID_EXSELF2_E;                           \
          _dg = MGRID_EXSELF2_E;                                               \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF3:                                                      \
        if (_s > MGRID_EXSELF3_swdis) {                                        \
          _g = MGRID_EXSELF3_D + _s*(MGRID_EXSELF3_C + _s*(MGRID_EXSELF3_B     \
                + _s*MGRID_EXSELF3_A));                                        \
          _dg = MGRID_EXSELF3_C + _s*(2*MGRID_EXSELF3_B                        \
              + _s*3*MGRID_EXSELF3_A);                                         \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF3_F + _s*MGRID_EXSELF3_E;                           \
          _dg = MGRID_EXSELF3_E;                                               \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF7:                                                      \
        if (_s > MGRID_EXSELF7_swdis) {                                        \
          _g = (MGRID_EXSELF7_D + _s*(MGRID_EXSELF7_C + _s*(MGRID_EXSELF7_B    \
                + _s*MGRID_EXSELF7_A))) / sqrt(_s);                            \
          _dg = (MGRID_EXSELF7_H + _s*(MGRID_EXSELF7_G + _s*(MGRID_EXSELF7_F   \
                + _s*MGRID_EXSELF7_E))) / (_s*sqrt(_s));                       \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF7_J + _s*MGRID_EXSELF7_I;                           \
          _dg = MGRID_EXSELF7_I;                                               \
        }                                                                      \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
    /* *(pdg) = _dg * (2.0 * r_a); */                                          \
    *(pdg) = _dg;                                                              \
  } while (0)


#define gamma_odd(pg, r, split)                                                \
  do {                                                                         \
    double _r = r;                                                             \
    double _r2 = _r*_r;                                                        \
    double _g = 0;                                                             \
    switch (split) {                                                           \
      case MGRID_ODDPR1:                                                       \
      case MGRID_LOWDEG1:                                                      \
        _g = 3./2 + _r2*(-1./2);                                               \
        break;                                                                 \
      case MGRID_ODDPR2:                                                       \
      case MGRID_LOWDEG2:                                                      \
      case MGRID_EXACT0:                                                       \
        _g = 2 + _r2*(-2 + _r);                                                \
        break;                                                                 \
      case MGRID_ODDPR3:                                                       \
      case MGRID_LOWDEG3:                                                      \
        _g = 9./4 + _r2*(-5./2 + _r2*(9./4 - _r));                             \
        break;                                                                 \
      case MGRID_ODDPR4:                                                       \
        _g = 21./8 + _r2*(-35./8 + _r2*(63./8 + _r*(-7 + _r*(15./8))));        \
        break;                                                                 \
      case MGRID_ODDPR5:                                                       \
      case MGRID_LOWDEG5:                                                      \
        _g = 45./16 + _r2*(-21./4 + _r2*(63./8 + _r2*(-45./4                   \
                + _r*(9 + _r*(-35./16)))));                                    \
        break;                                                                 \
      case MGRID_ODDPR6:                                                       \
        _g = 25./8 + _r2*(-15./2 + _r2*(63./4 + _r2*(-75./2                    \
                + _r*(45 + _r*(-175./8 + _r*4)))));                            \
        break;                                                                 \
      case MGRID_ODDPR7:                                                       \
        _g = 105./32 + _r2*(-275./32 + _r2*(297./16 + _r2*(-495./16            \
                + _r2*(1925./32 + _r*(-66 + _r*(945./32 + _r*(-5)))))));       \
        break;                                                                 \
      case MGRID_ODDPR8:                                                       \
        _g = 455./128 + _r2*(-715./64 + _r2*(3861./128 + _r2*(-2145./32        \
                + _r2*(25025./128 + _r*(-286 + _r*(12285./64 + _r*(-65         \
                        + _r*(1155./128))))))));                               \
        break;                                                                 \
      case MGRID_LOWDEG4:                                                      \
        _g = 5./2 + _r2*(-7./2 + _r2*(7./2 + _r2*(-5./2 + _r)));               \
        break;                                                                 \
      case MGRID_LOWDEG6:                                                      \
        _g = 385./128 + _r2*(-825./128 + _r2*(693./64 + _r2*(-825./64          \
                + _r2*(1925./128 + _r*(-11 + _r*(315./128))))));               \
        break;                                                                 \
      case MGRID_LOWDEG7:                                                      \
        _g = 819./256 + _r2*(-1001./128 + _r2*(3861./256                       \
              + _r2*(-1287./64 + _r2*(5005./256 + _r2*(-2457./128              \
                    + _r*(13 + _r*(-693./256)))))));                           \
        break;                                                                 \
      case MGRID_LOWDEG8:                                                      \
        _g = 441./128 + _r2*(-637./64 + _r2*(3003./128                         \
              + _r2*(-1287./32 + _r2*(7007./128 + _r2*(-5733./64               \
                    + _r*(91 + _r*(-4851./128 + _r*(6))))))));                 \
        break;                                                                 \
      case MGRID_LOWALT5_1:                                                    \
        _g = 175./64 + _r2*(-75./16 + _r2*(189./32 + _r2*(-75./16              \
                + _r2*(175./64 - _r))));                                       \
        break;                                                                 \
      case MGRID_LOWALT6_1:                                                    \
        _g = 189./64 + _r2*(-385./64 + _r2*(297./32 + _r2*(-297./32            \
                + _r2*(385./64 + _r2*(-189./64 + _r)))));                      \
        break;                                                                 \
      case MGRID_LOWALT7_1:                                                    \
        _g = 1617./512 + _r2*(-1911./256 + _r2*(7007./512 + _r2*(-2145./128    \
                + _r2*(7007./512 + _r2*(-1911./256 + _r2*(1617./512 - _r))))));\
        break;                                                                 \
      case MGRID_LOWALT8_1:                                                    \
        _g = 3465./1024 + _r2*(-9555./1024 + _r2*(21021./1024                  \
              + _r2*(-32175./1024 + _r2*(35035./1024 + _r2*(-28665./1024       \
                    + _r2*(24255./1024 + _r*(-15 + _r*(3003./1024))))))));     \
        break;                                                                 \
      case MGRID_LOWALT8_2:                                                    \
        _g = 429./128 + _r2*(-1155./128 + _r2*(2457./128 + _r2*(-3575./128     \
                + _r2*(3575./128 + _r2*(-2457./128 + _r2*(1155./128            \
                      + _r2*(-429./128 + _r)))))));                            \
        break;                                                                 \
      case MGRID_EXSFPC2:                                                      \
        if (_r > MGRID_EXSFPC2_swdis) {                                        \
          _g = MGRID_EXSFPC2_A + _r*(MGRID_EXSFPC2_B + _r*(MGRID_EXSFPC2_C     \
                + _r*(MGRID_EXSFPC2_D + _r*MGRID_EXSFPC2_E)));                 \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFPC2_F;                                                \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSFPQ2:                                                      \
        if (_r > MGRID_EXSFPQ2_swdis) {                                        \
          _g = MGRID_EXSFPQ2_A + _r*(MGRID_EXSFPQ2_B + _r*(MGRID_EXSFPQ2_C     \
                + _r*MGRID_EXSFPQ2_D));                                        \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFPQ2_E + _r2*MGRID_EXSFPQ2_F;                          \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSFRC2:                                                      \
        if (_r > MGRID_EXSFRC2_swdis) {                                        \
          _g = MGRID_EXSFRC2_A/_r + MGRID_EXSFRC2_B + _r*(MGRID_EXSFRC2_C      \
                + _r*(MGRID_EXSFRC2_D + _r*MGRID_EXSFRC2_E));                  \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFRC2_F;                                                \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSFRQ2:                                                      \
        if (_r > MGRID_EXSFRQ2_swdis) {                                        \
          _g = MGRID_EXSFRQ2_A/_r + MGRID_EXSFRQ2_B + _r*(MGRID_EXSFRQ2_C      \
                + _r*MGRID_EXSFRQ2_D);                                         \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFRQ2_E + _r2*MGRID_EXSFRQ2_F;                          \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXACT3:                                                       \
        if (_r > 7./8) {                                                       \
          _g = -19./15 + _r*(49./5 + _r*(-59./5 + _r*(64./15)));               \
        }                                                                      \
        else {                                                                 \
          _g = 191./120 + _r2*(-3./5);                                         \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXACT2:                                                       \
        if (_r > 3./4) {                                                       \
          _g = 5./7 + _r*(27./7 + _r*(-41./7 + _r*(16./7)));                   \
        }                                                                      \
        else {                                                                 \
          _g = 47./28 + _r2*(-5./7);                                           \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXACT1:                                                       \
        if (_r > 1./2) {                                                       \
          _g = 5./3 + _r + _r2*(-3 + _r*(4./3));                               \
        }                                                                      \
        else {                                                                 \
          _g = 11./6 - _r2;                                                    \
        }                                                                      \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
  } while (0)


#define dgamma_odd(pg, pdg, r, split)                                          \
  do {                                                                         \
    double _r = r;                                                             \
    double _r2 = _r*_r;                                                        \
    double _g = 0, _dg = 0;                                                    \
    switch (split) {                                                           \
      case MGRID_ODDPR1:                                                       \
      case MGRID_LOWDEG1:                                                      \
        _g = 3./2 + _r2*(-1./2);                                               \
        _dg = -_r;                                                             \
        break;                                                                 \
      case MGRID_ODDPR2:                                                       \
      case MGRID_LOWDEG2:                                                      \
      case MGRID_EXACT0:                                                       \
        _g = 2 + _r2*(-2 + _r);                                                \
        _dg = _r*(-4 + _r*3);                                                  \
        break;                                                                 \
      case MGRID_ODDPR3:                                                       \
      case MGRID_LOWDEG3:                                                      \
        _g = 9./4 + _r2*(-5./2 + _r2*(9./4 - _r));                             \
        _dg = _r*(-5 + _r2*(9 + _r*(-5)));                                     \
        break;                                                                 \
      case MGRID_ODDPR4:                                                       \
        _g = 21./8 + _r2*(-35./8 + _r2*(63./8 + _r*(-7 + _r*(15./8))));        \
        _dg = _r*(-35./4 + _r2*(63./2 + _r*(-35 + _r*(45./4))));               \
        break;                                                                 \
      case MGRID_ODDPR5:                                                       \
      case MGRID_LOWDEG5:                                                      \
        _g = 45./16 + _r2*(-21./4 + _r2*(63./8 + _r2*(-45./4                   \
                + _r*(9 + _r*(-35./16)))));                                    \
        _dg = _r*(-21./2 + _r2*(63./2 + _r2*(-135./2                           \
                + _r*(63 + _r*(-35./2)))));                                    \
        break;                                                                 \
      case MGRID_ODDPR6:                                                       \
        _g = 25./8 + _r2*(-15./2 + _r2*(63./4 + _r2*(-75./2                    \
                + _r*(45 + _r*(-175./8 + _r*4)))));                            \
        _dg = _r*(-15 + _r2*(63 + _r2*(-225                                    \
                + _r*(315 + _r*(-175 + _r*36)))));                             \
        break;                                                                 \
      case MGRID_ODDPR7:                                                       \
        _g = 105./32 + _r2*(-275./32 + _r2*(297./16 + _r2*(-495./16            \
                + _r2*(1925./32 + _r*(-66 + _r*(945./32 + _r*(-5)))))));       \
        _dg = _r*(-275./16 + _r2*(297./4 + _r2*(-1485./8                       \
                + _r2*(1925./4 + _r*(-594 + _r*(4725./16 + _r*(-55)))))));     \
        break;                                                                 \
      case MGRID_ODDPR8:                                                       \
        _g = 455./128 + _r2*(-715./64 + _r2*(3861./128 + _r2*(-2145./32        \
                + _r2*(25025./128 + _r*(-286 + _r*(12285./64 + _r*(-65         \
                        + _r*(1155./128))))))));                               \
        _dg = _r*(-715./32 + _r2*(3861./32 + _r2*(-6435./16                    \
                + _r2*(25025./16 + _r*(-2574 + _r*(61425./32 + _r*(-715        \
                        + _r*(3465./32))))))));                                \
        break;                                                                 \
      case MGRID_LOWDEG4:                                                      \
        _g = 5./2 + _r2*(-7./2 + _r2*(7./2 + _r2*(-5./2 + _r)));               \
        _dg = _r*(-7 + _r2*(14 + _r2*(-15 + _r*(7))));                         \
        break;                                                                 \
      case MGRID_LOWDEG6:                                                      \
        _g = 385./128 + _r2*(-825./128 + _r2*(693./64 + _r2*(-825./64          \
                + _r2*(1925./128 + _r*(-11 + _r*(315./128))))));               \
        _dg = _r*(-825./64 + _r2*(693./16 + _r2*(-2475./32                     \
                + _r2*(1925./16 + _r*(-99 + _r*(1575./64))))));                \
        break;                                                                 \
      case MGRID_LOWDEG7:                                                      \
        _g = 819./256 + _r2*(-1001./128 + _r2*(3861./256                       \
              + _r2*(-1287./64 + _r2*(5005./256 + _r2*(-2457./128              \
                    + _r*(13 + _r*(-693./256)))))));                           \
        _dg = _r*(-1001./64 + _r2*(3861./64 + _r2*(-3861./32                   \
                + _r2*(5005./32 + _r2*(-12285./64 + _r*(143                    \
                      + _r*(-2079./64)))))));                                  \
        break;                                                                 \
      case MGRID_LOWDEG8:                                                      \
        _g = 441./128 + _r2*(-637./64 + _r2*(3003./128                         \
              + _r2*(-1287./32 + _r2*(7007./128 + _r2*(-5733./64               \
                    + _r*(91 + _r*(-4851./128 + _r*(6))))))));                 \
        _dg = _r*(-637./32 + _r2*(3003./32 + _r2*(-3861./16                    \
                + _r2*(7007./16 + _r2*(-28665./32 + _r*(1001                   \
                      + _r*(-14553./32 + _r*(78))))))));                       \
        break;                                                                 \
      case MGRID_LOWALT5_1:                                                    \
        _g = 175./64 + _r2*(-75./16 + _r2*(189./32 + _r2*(-75./16              \
                + _r2*(175./64 - _r))));                                       \
        _dg = _r*(-75./8 + _r2*(189./8 + _r2*(-225./8 + _r2*(175./8            \
                  + _r*(-9)))));                                               \
        break;                                                                 \
      case MGRID_LOWALT6_1:                                                    \
        _g = 189./64 + _r2*(-385./64 + _r2*(297./32 + _r2*(-297./32            \
                + _r2*(385./64 + _r2*(-189./64 + _r)))));                      \
        _dg = _r*(-385./32 + _r2*(297./8 + _r2*(-891./16 + _r2*(385./8         \
                  + _r2*(-945./32 + _r*(11))))));                              \
        break;                                                                 \
      case MGRID_LOWALT7_1:                                                    \
        _g = 1617./512 + _r2*(-1911./256 + _r2*(7007./512 + _r2*(-2145./128    \
                + _r2*(7007./512 + _r2*(-1911./256 + _r2*(1617./512 - _r))))));\
        _dg = _r*(-1911./128 + _r2*(7007./128 + _r2*(-6435./64 + _r2*(7007./64 \
                  + _r2*(-9555./128 + _r2*(4851./128 + _r*(-13)))))));         \
        break;                                                                 \
      case MGRID_LOWALT8_1:                                                    \
        _g = 3465./1024 + _r2*(-9555./1024 + _r2*(21021./1024                  \
              + _r2*(-32175./1024 + _r2*(35035./1024 + _r2*(-28665./1024       \
                    + _r2*(24255./1024 + _r*(-15 + _r*(3003./1024))))))));     \
        _dg = _r*(-9555./512 + _r2*(21021./256 + _r2*(-96525./512              \
                + _r2*(35035./128 + _r2*(-143325./512 + _r2*(72765./256        \
                      + _r*(-195 + _r*(21021./512))))))));                     \
        break;                                                                 \
      case MGRID_LOWALT8_2:                                                    \
        _g = 429./128 + _r2*(-1155./128 + _r2*(2457./128 + _r2*(-3575./128     \
                + _r2*(3575./128 + _r2*(-2457./128 + _r2*(1155./128            \
                      + _r2*(-429./128 + _r)))))));                            \
        _dg = _r*(-1155./64 + _r2*(2457./32 + _r2*(-10725./64                  \
                + _r2*(3575./16 + _r2*(-12285./64 + _r2*(3465./32              \
                      + _r2*(-3003./64 + _r*(15))))))));                       \
        break;                                                                 \
      case MGRID_EXSFPC2:                                                      \
        if (_r > MGRID_EXSFPC2_swdis) {                                        \
          _g = MGRID_EXSFPC2_A + _r*(MGRID_EXSFPC2_B + _r*(MGRID_EXSFPC2_C     \
                + _r*(MGRID_EXSFPC2_D + _r*MGRID_EXSFPC2_E)));                 \
          _dg = MGRID_EXSFPC2_B + _r*(2*MGRID_EXSFPC2_C                        \
              + _r*(3*MGRID_EXSFPC2_D + _r*(4*MGRID_EXSFPC2_E)));              \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFPC2_F;                                                \
          _dg = 0;                                                             \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSFPQ2:                                                      \
        if (_r > MGRID_EXSFPQ2_swdis) {                                        \
          _g = MGRID_EXSFPQ2_A + _r*(MGRID_EXSFPQ2_B + _r*(MGRID_EXSFPQ2_C     \
                + _r*MGRID_EXSFPQ2_D));                                        \
          _dg = MGRID_EXSFPQ2_B + _r*(2*MGRID_EXSFPQ2_C                        \
              + _r*(3*MGRID_EXSFPQ2_D));                                       \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFPQ2_E + _r2*MGRID_EXSFPQ2_F;                          \
          _dg = _r*(2*MGRID_EXSFPQ2_F);                                        \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSFRC2:                                                      \
        if (_r > MGRID_EXSFRC2_swdis) {                                        \
          _g = MGRID_EXSFRC2_A/_r + MGRID_EXSFRC2_B + _r*(MGRID_EXSFRC2_C      \
                + _r*(MGRID_EXSFRC2_D + _r*MGRID_EXSFRC2_E));                  \
          _dg = -MGRID_EXSFRC2_A/_r2 + MGRID_EXSFRC2_C                         \
              + _r*(2*MGRID_EXSFRC2_D + _r*(3*MGRID_EXSFRC2_E));               \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFRC2_F;                                                \
          _dg = 0;                                                             \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSFRQ2:                                                      \
        if (_r > MGRID_EXSFRQ2_swdis) {                                        \
          _g = MGRID_EXSFRQ2_A/_r + MGRID_EXSFRQ2_B + _r*(MGRID_EXSFRQ2_C      \
                + _r*MGRID_EXSFRQ2_D);                                         \
          _dg = -MGRID_EXSFRQ2_A/_r2 + MGRID_EXSFRQ2_C                         \
              + _r*2*MGRID_EXSFRQ2_D;                                          \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSFRQ2_E + _r2*MGRID_EXSFRQ2_F;                          \
          _dg = _r*(2*MGRID_EXSFRQ2_F);                                        \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXACT3:                                                       \
        if (_r > 7./8) {                                                       \
          _g = -19./15 + _r*(49./5 + _r*(-59./5 + _r*(64./15)));               \
          _dg = 49./5 + _r*(-118./5 + _r*(64./5));                             \
        }                                                                      \
        else {                                                                 \
          _g = 191./120 + _r2*(-3./5);                                         \
          _dg = _r*(-6./5);                                                    \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXACT2:                                                       \
        if (_r > 3./4) {                                                       \
          _g = 5./7 + _r*(27./7 + _r*(-41./7 + _r*(16./7)));                   \
          _dg = 27./7 + _r*(-82./7 + _r*(48./7));                              \
        }                                                                      \
        else {                                                                 \
          _g = 47./28 + _r2*(-5./7);                                           \
          _dg = _r*(-10./7);                                                   \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXACT1:                                                       \
        if (_r > 1./2) {                                                       \
          _g = 5./3 + _r + _r2*(-3 + _r*(4./3));                               \
          _dg = 1 + _r*(-6 + _r*(4));                                          \
        }                                                                      \
        else {                                                                 \
          _g = 11./6 - _r2;                                                    \
          _dg = _r*(-2);                                                       \
        }                                                                      \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
    *(pdg) = _dg;                                                              \
  } while (0)


#else

  /* otherwise call externally linked functions */
  void mgrid_gamma(double *pg, double s, int32 split);
  void mgrid_dgamma(double *pg, double *pdg, double s, int32 split);

#define gamma  mgrid_gamma
#define dgamma  mgrid_dgamma

  void mgrid_gamma_odd(double *pg, double r, int32 split);
  void mgrid_dgamma_odd(double *pg, double *pdg, double r, int32 split);

#define gamma_odd  mgrid_gamma_odd
#define dgamma_odd  mgrid_dgamma_odd

#endif

  /* compute all derivatives of splitting up to n-1, store in array */
  void mgrid_ndgamma(double *pg, int32 n, double s, int32 split);

#ifdef __cplusplus
}
#endif

#endif /* SPLIT_H */
