/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * defeng.c
 */

#include <stdlib.h>
#include <string.h>
#include "mdsim/defeng.h"
#include "debug/debug.h"

#define NELEMS(x)  (sizeof(x) / sizeof(x[0]))

typedef struct Result_tag {
  double energy;
  int32 ozzy[3];
  MD_Fvec harriet;
#if 0
#endif
} Result;

static const MD_Member resultMemberList[] = {
  { MD_DOUBLE, 1, "energy" },
  { MD_INT32, 3, "ozzy" },
  { MD_FVEC, 1, "harriet" },
#if 0
#endif
};

typedef struct Param_tag {
  double cutoff;
} Param;

static const MD_Member paramMemberList[] = {
  { MD_DOUBLE, 1, "cutoff" },
};

typedef struct Engine_tag {
  /* required engine data arrays */
  MD_Engdata *atomprm;
  MD_Engdata *bondprm;
  MD_Engdata *angleprm;
  MD_Engdata *dihedprm;
  MD_Engdata *imprprm;
  MD_Engdata *nbfixprm;
  MD_Engdata *atom;
  MD_Engdata *bond;
  MD_Engdata *angle;
  MD_Engdata *dihed;
  MD_Engdata *impr;
  MD_Engdata *excl;
  MD_Engdata *pos;
  MD_Engdata *vel;
  MD_Engdata *result_engdata;
  MD_Engdata *param_engdata;

  /* errors */
  int32 err_unstable;

  /* result and param data */
  Result result;
  Param param;

  /* keep some separate simulation parameters */
  MD_Engdata *timestep;
  double dt;
} Engine;

static int32 run(MD_Front *f, int32 numsteps, int32 flags);


int32 default_engine_init(MD_Front *f, int32 flags)
{
  Engine *eng = NULL;
  int32 acc = MD_WRITE | MD_RESIZE;
#if 0
  int32 accrw = MD_READ | MD_WRITE | MD_RESIZE;
  MD_Attrib attr_result = { 0, 1, 1, MD_READ };
#endif
  int32 accrw = MD_READ | MD_WRITE | MD_RESIZE | MD_CBREAD;
  MD_Attrib attr_result = { 0, 1, 1, MD_READ | MD_CBREAD };
  MD_Attrib attr_param = { 0, 1, 1, MD_READ | MD_WRITE };
  MD_Attrib attr_timestep = { MD_DOUBLE, 1, 1, MD_READ | MD_WRITE };

  /* allocate internal data structure */
  if ((eng = (Engine *) calloc(1, sizeof(Engine))) == NULL) {
    return MD_error(f, MD_ERR_MEMALLOC);
  }

  /* setup engine */
  if (MD_setup_engine(f, eng)) return MD_FAIL;

  /* define types */
  attr_result.type = MD_new_type(f, "Result", resultMemberList,
      NELEMS(resultMemberList), sizeof(Result));
  if (attr_result.type == MD_FAIL) return MD_FAIL;
  attr_param.type = MD_new_type(f, "Param", paramMemberList,
      NELEMS(paramMemberList), sizeof(Param));
  if (attr_param.type == MD_FAIL) return MD_FAIL;

  /* define errors */
  eng->err_unstable = MD_new_error(f, "simulation unstable", 1);

  /* establish engine data arrays */
  if ((eng->atomprm = MD_engdata(f, "atomprm", MD_ATOMPRM, acc)) == NULL
      || (eng->bondprm = MD_engdata(f, "bondprm", MD_BONDPRM, acc)) == NULL
      || (eng->angleprm = MD_engdata(f, "angleprm", MD_ANGLEPRM, acc)) == NULL
      || (eng->dihedprm = MD_engdata(f, "dihedprm", MD_TORSPRM, acc)) == NULL
      || (eng->imprprm = MD_engdata(f, "imprprm", MD_TORSPRM, acc)) == NULL
      || (eng->nbfixprm = MD_engdata(f, "nbfixprm", MD_NBFIXPRM, acc)) == NULL
      || (eng->atom = MD_engdata(f, "atom", MD_ATOM, acc)) == NULL
      || (eng->bond = MD_engdata(f, "bond", MD_BOND, acc)) == NULL
      || (eng->angle = MD_engdata(f, "angle", MD_ANGLE, acc)) == NULL
      || (eng->dihed = MD_engdata(f, "dihed", MD_TORS, acc)) == NULL
      || (eng->impr = MD_engdata(f, "impr", MD_TORS, acc)) == NULL
      || (eng->excl = MD_engdata(f, "excl", MD_EXCL, acc)) == NULL
      || (eng->pos = MD_engdata(f, "pos", MD_DVEC, accrw)) == NULL
      || (eng->vel = MD_engdata(f, "vel", MD_DVEC, accrw)) == NULL
      || (eng->result_engdata = MD_engdata_buffer(f, "result", attr_result,
          &(eng->result))) == NULL
      || (eng->param_engdata = MD_engdata_buffer(f, "param", attr_param,
          &(eng->param))) == NULL
      || (eng->timestep = MD_engdata_buffer(f, "timestep", attr_timestep,
          &(eng->dt))) == NULL) {
    return MD_FAIL;
  }

  /* setup run routine */
  if (MD_setup_run(f, run)) return MD_FAIL;

  return 0;
}


void default_engine_done(MD_Front *f)
{
  Engine *eng = MD_engine_data(f);

  /* free memory allocated during init */
  free(eng);
}


int32 run(MD_Front *f, int32 numsteps, int32 flags)
{
  Engine *eng = MD_engine_data(f);
  int32 k;

  eng->result.energy = 3.14159;
  eng->result.ozzy[0] = 40;
  eng->result.ozzy[1] = 50;
  eng->result.ozzy[2] = 60;
  eng->result.harriet.x = -1.35;
  eng->result.harriet.y = -2.46;
  eng->result.harriet.z = -9.87;

  if (MD_ready_callback(f)) {
    /* printf("stepnum %d: processing callbacks\n", MD_stepnum(f)); */
    if (MD_exec_callback(f)) return MD_FAIL;
  }
  for (k = 0;  k < numsteps;  k++) {
    MD_incrstep(f, 1);
    if (MD_ready_callback(f)) {
      /* printf("stepnum %d: processing callbacks\n", MD_stepnum(f)); */
      if (MD_exec_callback(f)) return MD_FAIL;
    }
  }
  return 0;
}
