/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * const.h
 */

#ifndef CONST_H
#define CONST_H

#ifdef __cplusplus
extern "C" {
#endif

  /* Boolean constants */
  enum {
    FALSE = 0,
    TRUE = 1
  };

  /* file extensions */
#define FN_POS_EXT  ".coor"
#define FN_VEL_EXT  ".vel"
#define FN_BAK_EXT  ".BAK"

  /* some simparam defaults */
  enum {
    RESULTS_WIDTH = 13,
    RESULTS_HEADER_FREQ = 20,
    POTENTIAL_WIDTH = 13,
    POTENTIAL_HEADER_FREQ = 20
  };

  /* identifies potential types */
  enum {
    INVALID = -1, BOND = 1, ANGLE, DIHED, IMPR, ELEC, VDW, BOUND, EPOT
  };

  /* NAMD velocity conversion factor from its internal units into A/ps */
#define NAMD_PDBVELFACTOR  20.45482706

#ifdef __cplusplus
}
#endif

#endif /* CONST_H */
