/*
 * Copyright (C) 2006 by David J. Hardy.  All rights reserved.
 */

/**@file    setup.h
 * @brief   Lower-level routines for setting up force data structures.
 * @author  David J. Hardy
 * @date    2006
 *
 */

#ifndef SETUP_H
#define SETUP_H

#ifdef __cplusplus
extern "C" {
#endif

  int force_setup_domain(Force *fobj, ForceDomain *fdom,
      const MD_Dvec pos[], const int32 sel[], int32 sel_len);
  void force_cleanup_domain(Force *);

  int force_setup_selection(Force *fobj, ForceSelect *fsel);
  void force_cleanup_selection(Force *);

  int force_setup_gridcells(Force *, double mincellsize, int32 shell);
  void force_cleanup_gridcells(Force *);

  int force_setup_pairlists(Force *, double outer_cutoff,
      const int32 sel[], int32 sel_len);
  void force_cleanup_pairlists(Force *);

  int force_setup_vdwparams(Force *);
  void force_cleanup_vdwparams(Force *);

  int force_setup_exclusions(Force *);
  void force_cleanup_exclusions(Force *);

  int force_setup_bres(Force *);
  void force_cleanup_bres(Force *);

  int force_safe_buckingham_params(
      double *A,
      double *B,
      double *Rswitch,
      double *uRswitch,
      double *Rtop,
      double *uRtop,
      double a,
      double b,
      double c);

#ifdef __cplusplus
}
#endif

#endif /* SETUP_H */
