/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 */

#include <stdlib.h>
#include <string.h>
#include "force/force.h"
#include "debug/debug.h"


ForceParam *force_param_create(void)
{
  ForceParam *fprm;

  fprm = (ForceParam *) malloc(sizeof(ForceParam));
  if (fprm == NULL) {
    return NULL;
  }
  else if (force_param_initialize(fprm)) {
    force_param_cleanup(fprm);
    free(fprm);
    return NULL;
  }
  return fprm;
}


int force_param_initialize(ForceParam *fprm)
{
  ASSERT(fprm != NULL);

  /* clear memory */
  memset(fprm, 0, sizeof(ForceParam));

  /* set some default algorithmic parameters */
  fprm->shell_width = FORCE_DEFAULT_SHELL_WIDTH;
  fprm->cutoff_ratio = FORCE_DEFAULT_CUTOFF_RATIO;
  fprm->cell_margin = FORCE_DEFAULT_CELL_MARGIN;
  fprm->delta_dis = FORCE_DEFAULT_GRIDCELL_DELTA_DIS;
#if 0
  fprm->delta_dis = FORCE_DEFAULT_PAIRLIST_DELTA_DIS;
#endif

  return 0;
}


void force_param_destroy(ForceParam *fprm)
{
  force_param_cleanup(fprm);
  free(fprm);
}


void force_param_cleanup(ForceParam *fprm)
{
  ASSERT(fprm != NULL);
  /* no memory was allocated by us, simply reset contents */
  memset(fprm, 0, sizeof(ForceParam));
}
