/*
 * Copyright (C) 2004-2006 by David J. Hardy.  All rights reserved.
 *
 * force.c
 *
 * Create and destroy Force object.
 */

#include <stdlib.h>
#include "force/intdefn.h"
#include "debug/debug.h"


Force *force_create(ForceParam *fprm, ForceDomain *fdom, ForceSelect *fsel,
    const MD_Dvec initpos[])
{
  Force *fobj;

  fobj = (Force *) calloc(1, sizeof(Force));
  if (fobj == NULL) {
    return NULL;
  }
  else if (force_initialize(fobj, fprm, fdom, fsel, initpos)) {
    ERROR("force_initialize()");
    force_cleanup(fobj);
    free(fobj);
    return NULL;
  }
  return fobj;
}


void force_destroy(Force *fobj)
{
  force_cleanup(fobj);
  free(fobj);
}


const MD_Dvec *force_get_poswrap(const Force *fobj)
{
  return (const MD_Dvec *)(fobj->poswrap);
}


const MD_Dvec *force_get_scaled_coords(const Force *fobj)
{
  return (const MD_Dvec *)(fobj->trpos);
}


int32 **force_get_excl_list(const Force *fobj)
{
  return fobj->excl_list;
}


int32 **force_get_scaled14_list(const Force *fobj)
{
  return fobj->scaled14_list;
}


double force_get_volume(const Force *fobj)
{
  return fobj->volume;
}


const MD_Dvec *force_get_cell_center(const Force *fobj)
{
  return (const MD_Dvec *) &(fobj->center);
}


const MD_Dvec *force_get_cell_vectors(const Force *fobj)
{
  return (const MD_Dvec *) &(fobj->v1);
}


const double *force_get_cell_lengths(const Force *fobj)
{
  return (const double *) &(fobj->lv1);
}


const MD_Dvec *force_get_row_transform(const Force *fobj)
{
  return (const MD_Dvec *) &(fobj->ta1);
}


int32 force_get_cell_boundary(const Force *fobj)
{
  return fobj->is_periodic;
}


int32 force_get_domain_update(const Force *fobj)
{
  return fobj->is_domain_update;
}


int32 force_setup_scaled_minmax(Force *fobj)
{
  int32 current = fobj->is_minmax;
  fobj->is_minmax = (current == 0);  /* toggle Boolean 0/1 */
  return current;
}


const MD_Dvec *force_get_scaled_minmax(const Force *fobj)
{
  return (const MD_Dvec *) &(fobj->smin);
}


/* implement force_setup_lattice() in setup.c */


const MD_Dvec *force_get_lattice_spacings(const Force *fobj)
{
  return (const MD_Dvec *) &(fobj->dv1);
}
