/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/*
 * utility functions 
 */

#ifndef H_UTILITIES
#define H_UTILITIES

#ifdef __cplusplus
extern "C" {
#endif

#include <math.h>
#include <assert.h>

  /* required for alpha machine compiler */
#define OK 0  /* for function return value */
#define FAILURE 1


#define DIMENSION 3

  enum INDEX1 {X = 0, Y, Z, NIND1};
  enum INDEX2 {XX=0, XY, XZ, YY, YZ, ZZ, NIND2,
	       YX=XY, ZX=XZ, ZY=YZ};
  enum INDEX3 {XXX=0, XXY, XXZ, XYY, XYZ, XZZ, YYY, YYZ, YZZ, ZZZ, NIND3,
	       XYX=XXY, XZX=XXZ, XZY=XYZ, 
	       YXX=XXY, YXY=XYY, YXZ=XYZ, YYX=XYY, YZX=XYZ, YZY=YYZ,
	       ZXX=XXZ, ZXY=XYZ, ZXZ=XZZ, ZYX=XYZ, ZYY=YYZ, ZYZ=YZZ, ZZX=XZZ, 
	       ZZY=YZZ};

  enum MD_TYPE {ConstEnergy, ConstTemp, N_MD_TYPES};

  enum RUN_TYPE {THERMALIZATION, PRODUCTION};

  enum ElectroStatic_Solver_Tag {
    ES_NotUse,   /* no electrostatics interactions */
    ES_StandardEwald,
    ES_SPME, /* Smooth Particle-Mesh-Ewald */
    DIPOLE_POLY_StandEwald,
    DIPOLE_POLY_PME,
    ES_Nsolvers
  };


#ifdef CAUTIOUS
#  define ASSERT(condition) assert(condition)
#else
#  define ASSERT(condition)
#endif


  /* return the closest integer to x */
#define ANINT(x) ( (x) > floor(x) + 0.5 ? ceil(x):floor(x) )
  /* avoid the use of while in loops */
#define BOUND(d, L) \
  { MD_Double t = (d) / (L);  (d) -= ANINT(t) * (L); }
#define BOUND_VEC(v, L) \
  { BOUND(v.x, L.x); BOUND(v.y, L.y); BOUND(v.z, L.z); }

  /* when I am sure -L < d < L, e.g. when d is the difference of two
   *  position vectors within the cell, I can use this for fast computation */
#define SIMPLE_BOUND(d, L) \
  { if (d<-0.5*L) d+=L; else if (d>0.5*L) d-=L; }

#define SIMPLE_BOUND_VEC(v, L) \
  { SIMPLE_BOUND(v.x, L.x); SIMPLE_BOUND(v.y, L.y); SIMPLE_BOUND(v.z, L.z); }


#define MD_pvecLen(pv) (sqrt((pv)->x*(pv)->x + (pv)->y*(pv)->y \
                           + (pv)->z*(pv)->z))
#define MD_vecLen(v) (sqrt(v.x*v.x + v.y*v.y + v.z*v.z))
#define MD_vec_dot(v1, v2) ((v1).x*(v2).x + (v1).y*(v2).y + (v1).z*(v2).z)
#define MD_pvec_dot(pv1, pv2) ((pv1)->x * (pv2)->x \
                             + (pv1)->y * (pv2)->y \
                             + (pv1)->z * (pv2)->z)
#define MD_vec_add(v1, v2, vsum) {vsum.x = v1.x+v2.x; \
                                  vsum.y = v1.y+v2.y; \
                                  vsum.z = v1.z+v2.z;}
#define MD_pvec_add(pv1, pv2, pvsum) {(pvsum)->x = (pv1)->x + (pv2)->x; \
                                      (pvsum)->y = (pv1)->y + (pv2)->y; \
                                      (pvsum)->z = (pv1)->z + (pv2)->z;}
#define MD_vec_substract(v1, v2, vdiff) {(vdiff).x = (v1).x - (v2).x; \
                                  	 (vdiff).y = (v1).y - (v2).y; \
                                  	 (vdiff).z = (v1).z - (v2).z;}
#define MD_pvec_substract(pv1, pv2, pvdiff) \
                         {(pvdiff)->x = (pv1)->x - (pv2)->x; \
                      	  (pvdiff)->y = (pv1)->y - (pv2)->y; \
                       	  (pvdiff)->z = (pv1)->z - (pv2)->z;}
#define MD_vec_mul(v1, c, vsum) {(vsum).x = (c)*(v1).x; \
                                 (vsum).y = (c)*(v1).y; \
                                 (vsum).z = (c)*(v1).z;}
#define MD_pvec_mul(pv1, c, pvsum) {(pvsum)->x = (c)*(pv1)->x; \
                                    (pvsum)->y = (c)*(pv1)->y; \
                                    (pvsum)->z = (c)*(pv1)->z;}
#define MD_vec_mul_add(pos, vel, c) {(pos).x += (vel).x * (c); \
                                     (pos).y += (vel).y * (c); \
                                     (pos).z += (vel).z * (c);}
#define MD_vec_add_mul(v1, v2, c, vsum) {(vsum).x=((v1).x+(v2).x)*(c); \
                                         (vsum).y=((v1).y+(v2).y)*(c); \
					 (vsum).z=((v1).z+(v2).z)*(c);}
#define MD_vec_outproduct_add(f, r, virial) \
  {virial[0]=f.x*r.x; virial[1]=f.x*r.y; virial[2]=f.x*r.z; \
   virial[3]=f.y*r.x; virial[4]=f.y*r.y; virial[5]=f.y*r.z; \
   virial[6]=f.z*r.x; virial[7]=f.z*r.y; virial[8]=f.z*r.z;}   

#define MD_vec_cross(v1, v2, v) { \
  v.x = v1.y * v2.z - v1.z * v2.y; \
  v.y = v1.z * v2.x - v1.x * v2.z; \
  v.z = v1.x * v2.y - v2.x * v1.y; \
}


#ifdef __cplusplus
}
#endif


#endif
