/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#include <assert.h>
#include "fftw.h"
#include "rfftw.h"

#define M 2
#define N 2

int main(void)
{
  /*     [1  2]
   * a = [    ]
   *     [2  1]
   */
  double a[M*2*(N/2+1)] = {1.0, 2.0, 0.0, 0.0, 2.0, 1.0, 0.0, 0.0};
  double b[M*2*(N/2+1)];
  int n[2] = {M, N};
  int i;
  rfftwnd_plan p, pinv;

  assert(sizeof(double) == sizeof(fftw_real));

  memcpy(b, a, M*2*(N/2+1)*sizeof(double));
  
  p    = rfftwnd_create_plan(2, n, FFTW_REAL_TO_COMPLEX,
			     FFTW_MEASURE | FFTW_IN_PLACE | FFTW_USE_WISDOM);
  pinv = rfftwnd_create_plan(2, n, FFTW_COMPLEX_TO_REAL,
			     FFTW_MEASURE | FFTW_IN_PLACE | FFTW_USE_WISDOM);

  rfftwnd_one_real_to_complex(p, a, NULL);
  rfftwnd_one_complex_to_real(pinv, (fftw_complex *) a, NULL);

  for(i=0; i<M*2*(N/2+1); i++) {
    printf("%f, %f\n", a[i]/(M*N), b[i]);
  }

  rfftwnd_destroy_plan(p);
  rfftwnd_destroy_plan(pinv);


  return 0;
}
