/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef ELECTRO_REC_H
#define ELECTRO_REC_H

#ifdef __cplusplus
extern "C" {
#endif


#include "standEwald.h"

  /* Allocate memory and store reciprocal lattice vectors and potential.
   * The reciprocal lattice computation is abstracted to be a sum 
   * over "nreclatt" number of vectors and the corresponding "potential".
   * the "cutoff" criteria is not needed any more.
   */
  MD_Errcode init_rec(struct standEwald_Tag *se); 
  MD_Errcode destroy_rec(struct standEwald_Tag *se);

  /* both do: 
   *   compute charge--charge energy, force, -G1q from reciprocal summ, 
   * dipole_rec_setup also compute:
   *   internal representantation of the reciprocal part of G2/G3 matrix:
   *            coskr and sinkr matrix
   *            structure factor (real,imaginary)
   */
  void charge_rec_setup(struct standEwald_Tag *se);
  void dipole_rec_setup(struct standEwald_Tag *se);

  MD_Double calc_kcut(MD_Double beta, MD_Double errTol);

  /*
   * ---- The following functions are only needed for dipole computations --- 
   */


  /* the recirpocal sum of the charge-dipole, dipole-dipole force, energy */
  void compute_rec_dipole_force(struct standEwald_Tag *se);

  void add_recddforce(struct standEwald_Tag* se);

  /* compute Matrix vector product G2rec * v and add it to vector G2v, 
   * so the function assumes G2v is already initialized before calling it 
   */
  void add_recG2v(const struct standEwald_Tag *se, 
		  const MD_Double *v, MD_Double *G2v);

  void add_rec_pseudores(struct standEwald_Tag *se, 
			 const MD_Double *v, MD_Int flag, 
			 MD_Double *pseudores);

  void compute_recG2q(struct standEwald_Tag *se); 


#ifdef __cplusplus
}
#endif
#endif
