/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef ELECTRO_DIR_H
#define ELECTRO_DIR_H
#include "standEwald.h"

MD_Errcode init_dir(struct standEwald_Tag *se);
MD_Errcode destroy_dir(struct standEwald_Tag *se);
MD_Double calc_beta(MD_Double rc, MD_Double errTol);

/* 
 * both compute: 
 *    1. charge--charge energy from the direct sum, 
 *    2. direct part of -G1q,
 * dipole_dir_setup also compute the elements of G2, G3 matrices for the 
 * direct sum
 */
void charge_dir_setup(struct standEwald_Tag *se); 
void dipole_dir_setup(struct standEwald_Tag *se);

/* for direct sum   
 * charge_compute_gbar_dir: compute matrix elements of G0, G1 (direct part)
 * dipole_compute_gbar_dir: compute matrix elements of G0, G1, G2, G3 
 *                          (direct part)
 */
/* this is for debug purpose */
void charge_compute_gbar_dir(const struct standEwald_Tag *se, 
			     const MD_Dvec r,  
			     const MD_Int i,
			     const MD_Int j,
			     MD_Double *g0, 
			     MD_Dvec *g1);
void dipole_compute_gbar_dir(const struct standEwald_Tag *se, 
			     const MD_Dvec r,
			     const MD_Int i, 
			     const MD_Int j,  
			     MD_Double *g0, 
			     MD_Dvec *g1,
			     MD_Double *g2,  /* size 6 */ 
			     MD_Double *g3   /* size 10 */);

void compute_dirG2v(const struct standEwald_Tag *se, 
		    const MD_Double *v, MD_Double *g2v);

void compute_dir_pseudores(const struct standEwald_Tag *se, 
			   const MD_Double *v, const MD_Int flag, 
			   MD_Double *g2v);

/* compute the direct sum contribution to the charge-dipole, dipole-dipole
 * force
 */
void compute_dir_dipole_force(struct standEwald_Tag *se);


#endif
