/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#include "mdtypes.h"

#ifndef RATTLE_H
#define RATTLE_H

#ifdef __cplusplus
extern "C" {
#endif

  struct Rattle_Water {
    MD_Double bondOH, bondHH, angle_HOH; /* constraint for water molecule */
    MD_Double massO, massH;
    MD_Double errTol2;  /* error tolerance square */
    MD_Double bond_errTol;   /* for checking purpose */
    MD_Double vel_errTol;    
    MD_Dvec *old_pos;   /* old position */
    MD_Int natoms;
    MD_Int maxiter;    /* maximum iteration in shake */
  };

  void rattle_init(struct Rattle_Water *sw, const MD_Double bondOH, 
		  const MD_Double angle_HOH, 
		  const MD_Double massO, const MD_Double massH,
		  const MD_Int natoms);

  void rattle_destroy(struct Rattle_Water *sw);

  MD_Errcode rattle1(struct Rattle_Water *sw, const MD_Int iatom, 
		     MD_Dvec *rnew, MD_Dvec *vel, const MD_Double deltaT);

  MD_Errcode rattle2(struct Rattle_Water *sw,
		     const MD_Dvec *r, MD_Dvec *v, const MD_Double deltaT);

  void rattle_prepare(struct Rattle_Water *sw, const MD_Dvec *old_pos);

#ifdef __cplusplus
}
#endif


#endif
