/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/********************************************************
*							*
*  Note:						*
*   1. rannyu():  X2(kai-square) test shows, for ntot   *
*      = 10^6, NBins = 10, x2 = 4.8118;                 *
*      Probability(x^2 < 4.8118^2) = 0.994              *
*      (ref. Notebook3, page3)				*
*							*
********************************************************/


#ifndef RANDOM_H
#define RANDOM_H

#ifdef __cplusplus
extern "C" {
#endif

/* generate random numbers evenly distributed between 0 and 1. */
double rannyu(void);
/* generate normal distribution r.n., with mean = 0, var = 1. */
double rannyu_normal(void);
/* return sin(theta) and cos(theta), where theta is evenly
 * distributed between 0 and 2*PI.*/
void rannyu_angle(double *sintheta, double *costheta);
/* return a 3-dimensional random direction vector with unit
 * length.*/
void rannyu_vector3(double *p);

#ifdef __cplusplus
}
#endif

#endif

