/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/*
 * the module contains a pool of previous vectors (e.g. dipoles) 
 * and use various specified prediction method to predict the value
 * for the next timestep.
 */

#ifndef PREDICTOR_H
#define PREDICTOR_H

#ifdef __cplusplus
extern "C" {
#endif

#include "vecbuffer.h"

typedef enum Prediction_Type {
  Polynomial = 0,
  dPolynomial,
  Time_Reversible,
  TR_HO,
  Zero,
  LeastSquare,
  ConstraintLeastSquare,
  dLeastSquare,
  dConstraintLeastSquare,
  TimeReversibleLeastSquare,
  NPtypes
} Prediction_Type;

struct Predictor_Tag {
  Prediction_Type pred_type;
  MD_Int degree;
  struct VecBuffer_Tag* old_vectors;
  MD_Double *coeff;  /* coefficient */
  MD_Double **pvec; /* an array of vector pointers */
};

MD_Int predictor_init(struct Predictor_Tag *pred, Prediction_Type pred_type,
                      MD_Int pred_degree, MD_Int veclen, MD_Int restart);
MD_Int predictor_destroy(struct Predictor_Tag *pred); 
MD_Int predictor_predict(struct Predictor_Tag *pred, MD_Double *predvec);
MD_Int predictor_update(struct Predictor_Tag *pred, const MD_Double *newvec);
MD_Int predictor_get_degree(struct Predictor_Tag *pred);
Prediction_Type predictor_get_type(struct Predictor_Tag *pred);

#endif

