/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/*
 * a sub-module of dsolver, used to precondition Chebyshev or CG iterative
 * method.
 */

#ifndef PRECONDITIONER_H
#define PRECONDITIONER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "mdtypes.h"

struct Preconditioner_Tag
{
  MD_Int natoms;   
  MD_Double rcut;
  MD_Dvec *ppos;
  MD_Double *pdiag;
  MD_Dvec systemsize; /* for computing the real distance */
  MD_Int maxneibrs;   /* not elegant */
  MD_Int **neibrlist;  /* self-maintained */
  MD_Int *nneibrs;
  MD_Int **coarse_neibrlist;  /* just 3 pointers */
  MD_Int *coarse_nneibrs;
  MD_Int **pexcllist; 
  MD_Int degree; 
};

MD_Errcode preconditioner_init(struct Preconditioner_Tag *precond,
			       const MD_Int natoms, const MD_Double rcut, 
                               MD_Dvec *pos, MD_Double *diag, 
                               MD_Dvec systemsize, MD_Int **excllist,
                               const MD_Int maxneibrs, MD_Int **neibrlist,
                               MD_Int *nneibrs, const MD_Int degree);
MD_Errcode preconditioner_destroy(struct Preconditioner_Tag *precond);
void preconditioner_setup(struct Preconditioner_Tag *precond);
void preconditioner_solve(struct Preconditioner_Tag *precond,
			              const MD_Double *rhs, MD_Double *solution);

#ifdef __cplusplus
}
#endif

#endif
