/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef MY_ERFC_H
#define MY_ERFC_H

#include "mdtypes.h"

struct Erfc_Tag {
  MD_Int np; /* number of points */
  MD_Double *f;
  MD_Double *fp;
  MD_Double xmax;
  MD_Double dx;
};

MD_Errcode erfc_init(struct Erfc_Tag *myerfc);
MD_Double erfc_eval(const struct Erfc_Tag *myerfc, const MD_Double x);
MD_Errcode erfc_destroy(struct Erfc_Tag *myerfc);


#endif
