/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

#ifndef LATTICE_H
#define LATTICE_H


#ifdef __cplusplus
extern "C" {
#endif

#include "mdtypes.h" 

  struct Lattice_Tag {
    MD_Dvec a1, a2, a3;  /* real lattice vectors */
    MD_Dvec b1, b2, b3;  /* reciprocal lattice vectors (more or less) */
    MD_Dvec corner;      /* rear, left, bottom corner */
    int p1, p2, p3;     /* periodic along this lattice vector? */
  };


  void lattice_set(struct Lattice_Tag*, MD_Dvec a1, MD_Dvec a2, MD_Dvec a3, 
		   MD_Dvec origin);

  MD_Int lattice_is_orthogonal(const struct Lattice_Tag*);

  MD_Double lattice_volume(const struct Lattice_Tag*);



#ifdef __cplusplus
}
#endif


#endif
