/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/* 
 * this is a small module under "standEwald" to compute explicitly the
 * G0, G1, G2, G3 matrices and output them into a file. 
 * The module is for research purpose because in real MD simulation, 
 * G2 should not be explicitly computed.
 */

#ifndef EXPLICITG_H
#define EXPLICITG_H

#include "standEwald.h"

#ifdef __cplusplus
extern "C" {
#endif

/* once stdEw_init is called, I can call this function to compute G matrices
 */
void explicitG(const struct standEwald_Tag* se, 
	       const char *filename,
	       MD_Double** g0tot, 
	       MD_Double** g1tot,
	       MD_Double** g2tot,
	       MD_Double** g3tot);
void explicitG2(const struct standEwald_Tag* se, 
	       const char *filename,
	       MD_Double** g0tot, 
	       MD_Double** g1tot,
	       MD_Double** g2dir,
	       MD_Double** g2rec);
void explicitG_destroy(void);
void explicitG_compute_G2d(const MD_Double* d, const int matrixsize);

#ifdef __cplusplus
}
#endif

#endif
