/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/*************************************************************************
 * 
 * electro.h: electrostatic solver interface, base class. 
 *
 *************************************************************************/

#ifndef ELECTRO_H
#define ELECTRO_H

#ifdef __cplusplus
extern "C" {
#endif

#include "mdtypes.h"
#include "dsolvers.h"
#include "data.h"

  struct Electro_Tag {
    void *electro_ptr;
    enum ElectroStatic_Solver_Tag method;
  };
 
  /* "void*": generic pointer */
  MD_Errcode electro_init(struct Electro_Tag* electro, void* parameters, 
			  const enum ElectroStatic_Solver_Tag method);
  MD_Errcode electro_destroy(struct Electro_Tag* electro);
  MD_Errcode electro_compute(struct Electro_Tag* electro);

  MD_Double electro_get_energy(const struct Electro_Tag* electro);
  const MD_Dvec* electro_get_force(const struct Electro_Tag* electro);
  const MD_Double* electro_get_dipole(const struct Electro_Tag* electro);
  void electro_fill_diagonal(const struct Electro_Tag* electro, MD_Double *d);

  /* flag = 0, compute -G2d, result array length is 3*natoms 
   * flag = 1, compute -G1q - G2d */
  void electro_compute_pseudores(struct Electro_Tag* electro, 
				 const MD_Double *d, const MD_Int flag, 
				 MD_Double *pseudores);
  
  MD_Errcode electro_dump_dipole(const struct Electro_Tag* electro, 
				 const char* filename);

#ifdef __cplusplus
}
#endif


#endif
