/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */



/* The dipole equation  (G2 + D) d = (-G1q) is solved approximately
 * by d = P(G2) * (-G1q), where P(x) is a polynomial. The polynomial
 * is chosen so that the solution is optimal in either 2-norm or A-norm.
 * 
 */

#ifndef DPOLY_H
#define DPOLY_H

#include "pme.h"


struct DPoly_Tag
{
  struct Pme_Tag *pme;
  MD_Double *dipoles;
  MD_Double *gridpotens;
  MD_Double *invdiag;  /* diag=\alpha^{-1} - 4*beta^3/(3*sqrt(pi)) */
  MD_Double *work;
  MD_Int degree; 
} DPoly;

MD_Errcode dpoly_init(struct DPoly_Tag *dp, struct PmeParams_Tag *params,
		      MD_Int degree);
MD_Errcode dpoly_destroy(struct DPoly_Tag *dp);

MD_Errcode dpoly_compute(struct DPoly_Tag *dp);

const MD_Double* dpoly_get_dipole(const struct DPoly_Tag *dp);
MD_Double dpoly_get_energy(const struct DPoly_Tag *dp);
const MD_Dvec* dpoly_get_force(const struct DPoly_Tag *dp);

#endif
