/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/*
 * main program. 
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "data.h"
#include "force.h"
#include "utilities.h"
#include "timer.h"
#include "unit.h"
#include "dipole_poly.h"


int main(void)
{
  struct Data_Tag* data;

  Model_Types model = RPOL;  /* ARGON, SPC, RPOL, POL3, POL1 */
  /*Picard, damPicard, GaussSeidel, CG, JCG_X, JCG_R, QCG_X, Chebyshev,
    dampCheby */
  MD_Int restart = 1; 
  MD_Double tstart = time_of_day();
  struct Dsolver_Parameters_Type dsolver_param = {
    Zero, 0, Chebyshev, 1, 100, 1e-3 * DEBYE * DEBYE
  }; 

  printf("#################################################\n");
  printf("# machine: "); fflush(stdout);
  system("uname -n"); 
  printf("# directory: "); fflush(stdout);
  system("pwd"); 
  printf("# compile time: %s, %s\n", __TIME__, __DATE__);
  printf("# start running time: "); fflush(stdout);
  system("date");
  printf("#################################################\n");
  printf("\n");  fflush(stdout);


  /*
  if (2 != argc) { 
    printf("run as: driver prediction_degree \n");  
    exit(1);  
  } 
  prediction_degree = atoi(argv[1]);  
  */

  if ((data = calloc((size_t)1, sizeof(struct Data_Tag))) == NULL) {
    fprintf(stderr, "***cannot allocate space for data\n");
    return FAILURE;
  } else {
    printf("allocate %d bytes for \"data\".\n", (int) sizeof(struct Data_Tag));
  }

  assert(model < NMODELS);

  fprintf(stderr, "to initialize data structure ... \n");
  if (data_routines[model].init_function(data, restart)) {
    fprintf(stderr, "failed to init data\n");
    return FAILURE;
  }

#ifdef DEBUG
  fprintf(stderr, "to output data\n");
  output_data(data); 
#endif

  fprintf(stderr, "to initialize force parameters ....\n");
  {
    struct Force_init_Tag init_data;
    init_data.data = data;
    init_data.dsolver_param = dsolver_param;

    if (force_init(data->force, &init_data)) {
      fprintf(stderr, "*** failed to init force\n");
      return FAILURE;   
    }
  }

  force_compute(data->force);

  data_print_energy(data, 0);

  {
    FILE *fd = fopen("energy_force", "wb");

    fprintf(stderr, "to output dipole, energy, force to file energy_force...\n");
    assert(NULL != fd);
    {
#ifndef DIPOLE_POLY
    struct Electro_Tag *electro = data->force->fnonbond->electro;
    fwrite(dsolver_get_dipole(electro->dsolver), sizeof(MD_Double),
	   3*electro->natoms, fd); 
#else
    struct Dipole_Poly_Tag *dp = data->force->fnonbond->electro;
    struct Electro_Tag *electro = &(dp->electro);
    fwrite(dp->dipole, sizeof(MD_Double), (size_t)(3*data->natoms), fd); 
#endif
    fwrite(&(electro->energy), sizeof(MD_Double), 1, fd); 
    fwrite(electro->force, sizeof(MD_Double), (size_t)(3*data->natoms), fd);
    fclose(fd);
    }
  }

  data_routines[model].destroy_function(data);
  fprintf(stderr, "done!\n\n");

  printf("time cost is %f\n", time_of_day() - tstart);

  return 0;
}

