/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/*
 * dealing with B-spline interpolation and reciprocal force computation.
 *
 */ 
#ifndef PMEREALSPACE_H
#define PMEREALSPACE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "PmeBase.h"
#include "lattice.h"

  struct PmeRealSpace_Tag  /* responsible for B-spline interpolation */
  {
    MD_Int natoms;
    struct PmeGrid_Tag myGrid;
    MD_Double *M, *dM, *ddM;  /* B-spline, and its first,second derivatives */
  };

  MD_Errcode pmerealspace_init(struct PmeRealSpace_Tag *prs,  
			       const struct PmeGrid_Tag *grid,
			       const MD_Int natoms); 
  MD_Errcode pmerealspace_destroy(struct PmeRealSpace_Tag *prs);

  /* compute grid charge: q_h (q_arr), or Ih0^T * q */
  void pmerealspace_fill_bspline1(struct PmeRealSpace_Tag *prs, 
				  const MD_Dvec *scaled_pos);
  void pmerealspace_fill_charges(const struct PmeRealSpace_Tag *prs,
				 const MD_Dvec *scaled_pos,
				 const MD_Double *charge, 
				 MD_Double *q_arr);
  /* compute reciprocal force */ 
  void pmerealspace_charge_calc_force(struct PmeRealSpace_Tag *prs,
				      MD_Double *q_arr,
				      const MD_Dvec *scaled_pos, 
				      const MD_Double *charge, 
				      const struct Lattice_Tag lattice,
				      MD_Dvec *force);

  /* ------------------- dipole function ---------------------------- */
  void pmerealspace_fill_bspline2(struct PmeRealSpace_Tag *prs, 
				  const MD_Dvec *scaled_pos);
  /* compute Ih1^T*d */
  void pmerealspace_fill_dipoles(const struct PmeRealSpace_Tag *prs,
				 const MD_Dvec *scaled_pos, 
				 const struct Lattice_Tag lattice,
				 const MD_Double *dipole,
				 MD_Double *d_arr);
  /* compute Ih1 * d_arr */
  void pmerealspace_ungrid_dipoles(const struct PmeRealSpace_Tag *prs,
				   const MD_Dvec *scaled_pos,
				   const struct Lattice_Tag lattice,
				   const MD_Double *d_arr,
				   MD_Double *dipole);
  void pmerealspace_dipole_calc_force(const struct PmeRealSpace_Tag *prs,
				      const MD_Double *vh, 
				      const MD_Dvec *scaled_pos, 
				      const MD_Double *charge,
				      const MD_Double *dipole,
				      const struct Lattice_Tag lattice,
				      MD_Dvec *force);
#ifdef __cplusplus
}
#endif

#endif /* PMEREALSPACE_H */
