/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef BERENSEN_WC_H
#define BERENSEN_WC_H

#include "data.h"
#include "force.h"

/*
 * Berendsen weak-coupling algorithm for constant tempereature simulations.
 *
 */

#ifdef __cplusplus
extern "C" {
#endif

struct Berendsen_wc_Tag
{
  struct Force_Tag *force;
  struct Data_Tag *data;
  MD_Double temperature;  /* Kelvin */
  MD_Dvec *vel;
  MD_Dvec *velold;  

  MD_Double relaxation_time; 
  MD_Double desired_kineticE;

  MD_Int output_freq;
};

MD_Errcode ber_init(struct Berendsen_wc_Tag *ber, struct Force_Tag *force, 
		    struct Data_Tag *data, 
		    const MD_Double temperature /* Kelvin */ );
MD_Errcode ber_run(struct Berendsen_wc_Tag *ber, const MD_Int nsteps,
		   const enum RUN_TYPE run_type);
MD_Errcode ber_destroy(struct Berendsen_wc_Tag *ber);
MD_Double ber_get_pv_over_nkT(const struct Berendsen_wc_Tag *ber);

#ifdef __cplusplus
}
#endif

#endif
