/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * param.h
 */

#ifndef PARAM_H
#define PARAM_H

#include "mdapi/mdtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct Param_tag {
    double cutoff;
    double switchDist;
    char switching[4];
    char exclude[12];
    double dielectric;
    double scaling;
    char fullDirect[4];
    char sphericalBC[4];
    MD_Dvec sphericalBCCenter;
    double sphericalBCr1;
    double sphericalBCr2;
    double sphericalBCk1;
    double sphericalBCk2;
    int32 sphericalBCexp1;
    int32 sphericalBCexp2;
    char cylindricalBC[4];
    char cylindricalBCAxis[4];
    MD_Dvec cylindricalBCCenter;
    double cylindricalBCr1;
    double cylindricalBCr2;
    double cylindricalBCl1;
    double cylindricalBCl2;
    double cylindricalBCk1;
    double cylindricalBCk2;
    int32 cylindricalBCexp1;
    int32 cylindricalBCexp2;
    MD_Dvec cellBasisVector1;
    MD_Dvec cellBasisVector2;
    MD_Dvec cellBasisVector3;
    MD_Dvec cellOrigin;
  /*** mgrid params ***/
    char mgrid[8];
    double mgridLength;
    double mgridCutoff;
    double mgridSpacing;
    int32 mgridNspacings;
    int32 mgridNlevels;
    char mgridApprox[12];
    char mgridSplit[12];
  /*** pmetest params ***/
    char pmetest[8];
    double pmetestCutoff;
    double pmetestTolerance;
    int32 pmetestInterpOrder;
    int32 pmetestGridSizeX;
    int32 pmetestGridSizeY;
    int32 pmetestGridSizeZ;
  /*** correction for constant linear momentum ***/
    char correctLinmo[12];
  /*** kludge ***/
    int32 outputMomenta;
    int32 outputPressure;
    int32 outputTiming;
  /*** shadow Hamiltonian ***/
    char shadow[8];
  /*** energy minimization ***/
    char cgmin[4];
    int32 cgmineval;
    double cgmindis;
    double cgmintol;
  /*** buckingham potential ***/
    char buckingham[4];
    char bucknodispersion[4];
    char buckparam[8];
    char bucksafe[8];
  /*** coupling to temperature bath ***/
    char temperatureBath[8];
    double targetTemperature;
    double relaxationTime;
  /*** explicit Nose-Hoover ***/
    char noseHoover[8];
    double nhTemperature;
    double nhTimescale;
  /*** for harmonic constraints ***/
    double constraintScaling;
    char selectConstraints[4];
    char selectConstrX[4];
    char selectConstrY[4];
    char selectConstrZ[4];
  /*** thermalized Drude oscillators ***/
    char drude[8];
    char useRoux[4];
    char useChen[4];
    double druComTemp;
    double druBondTemp;
    double druComTimescale;
    double druBondTimescale;
    int32 druMultisteps;
  /*** rigid waters ***/
    char rigidBonds[8];
    char useSettle[4];
  } Param;

#ifdef __cplusplus
}
#endif

#endif /* PARAM_H */
