#
# Copyright (C) 2003-2005 by David J. Hardy.  All rights reserved.
#
# src.mk
# build MDX source modules

# export all variables to recursive calls, except for the linking commands,
# for which the automatic variables are expanded wrong if exported
export
unexport link_static
unexport link_dynamic
unexport link_plugin
unexport link_bin
unexport link_demo

# find C/C++ souce files
vpath %.c $(srcdir)/$(SRC)
vpath %.cc $(srcdir)/$(SRC)
vpath %.C $(srcdir)/$(SRC)
vpath %.cxx $(srcdir)/$(SRC)

# list of non-file targets
.PHONY : $(SRC) $(BUILD_TYPE)

# incrementally set "typelist" to list of types to build
# as indicated both by local TYPE and global BUILD_TYPE variables
# order might be sensitive - libraries, plugins, bins, demos
typelist :=

ifneq (,$(findstring lib,$(TYPE)))
typelist += $(findstring dynamic,$(BUILD_TYPE))
typelist += $(findstring static,$(BUILD_TYPE))
endif

ifneq (,$(findstring plugin,$(TYPE)))
typelist += $(findstring plugin,$(BUILD_TYPE))
endif

ifneq (,$(findstring bin,$(TYPE)))
typelist += $(findstring bin,$(BUILD_TYPE))
endif
# end setting "typelist"

# list of object directories where building occurs
buildirlist := $(patsubst %,%/$(SRC),$(addprefix $(objdirprefix),$(typelist)))

# list of object files to be built
objlist := $(patsubst %,%.o,$(basename $(OBJ)))

# optional library support
ifneq (,$(strip $(OPTLIB)))
# search dirs in order for optional libs, take first match
full_optlib := $(foreach name,$(OPTLIB),$(firstword $(wildcard $(addsuffix /lib$(name).*,$(if $(OPTLIBDIR),$(OPTLIBDIR),$(libdir))))))
# "optlib" is subset of "OPTLIB" that exists
optlib := $(patsubst lib%,%,$(basename $(notdir $(full_optlib))))
# define conditional compilation macros for existing optional libs
CPPFLAGS += $(addprefix -DMDX_OPTLIB_,$(optlib))
# tell linker to explicitly search these directories
optlib_dirlist := $(patsubst %/,%,$(dir $(full_optlib)))
# library link flags filters out any nonexistent optional libs
liblist := $(addprefix -l,$(filter-out $(filter-out $(optlib),$(OPTLIB)),$(LIB)))
else
# library link flags
liblist := $(addprefix -l,$(LIB))
endif

# "demolist" is non-empty if there are demos to build
ifeq (yes,$(strip $(BUILD_DEMO)))
demolist := $(strip $(DEMO))
demoobjlist := $(patsubst %,%.o,$(basename $(DEMOOBJ)))
demoliblist := $(addprefix -l,$(DEMOLIB)) $(liblist)
buildirlist += $(addprefix $(objdirprefix),demo/$(SRC))
endif

# if no install, need to modify INSTALL_LIB to local lib directory
ifneq (yes,$(strip $(INSTALL)))
INSTALL_LIB := $(libdir)
endif

# see if we need to link using C++ compiler
ifneq (yes,$(LINKCPP))
srclist := $(wildcard $(addprefix $(srcdir)/$(SRC)/,$(addsuffix .*,$(basename $(OBJ)))))
# set LINKCPP to "yes" if any current source files have suffix .cc .C .cxx
LINKCPP := $(sort $(foreach s,.cc .C .cxx,$(if $(findstring $(s),$(suffix $(srclist))),yes)))
endif

# define static link command
ifndef link_static
define link_static
rm -f $@ ; ar rcs $@ $^
endef
endif

# modify flags for compiling static libraries
ifeq (static,$(MAKECMDGOALS))
CPPFLAGS += -DMDX_STATIC
endif

# define dynamic link command
ifndef link_dynamic
ifeq (yes,$(LINKCPP))
define link_dynamic
$(CXX) $(CXXFLAGS) $(TARGET_OS) $(dlib_linkflags) $^ -o $@ $(liblist)
endef
else
define link_dynamic
$(CC) $(CFLAGS) $(TARGET_OS) $(dlib_linkflags) $^ -o $@ $(liblist)
endef
endif
endif

# modify flags for compiling dynamic libraries
ifeq (dynamic,$(MAKECMDGOALS))
CPPFLAGS += -DMDX_DYNAMIC
CFLAGS += $(dlib_flags)
CXXFLAGS += $(dlib_flags)
endif

# define plugin link command
ifndef link_plugin
ifeq (yes,$(LINKCPP))
define link_plugin
$(CXX) $(CXXFLAGS) $(TARGET_OS) $(plug_linkflags) $^ -o $@ $(liblist)
endef
else
define link_plugin
$(CC) $(CFLAGS) $(TARGET_OS) $(plug_linkflags) $^ -o $@ $(liblist)
endef
endif
endif

# modify flags for compiling plugins
ifeq (plugin,$(MAKECMDGOALS))
CPPFLAGS += -DMDX_PLUGIN
CFLAGS += $(plug_flags)
CXXFLAGS += $(plug_flags)
endif

# define binary executable link command
ifndef link_bin
ifeq (yes,$(LINKCPP))
define link_bin
$(CXX) $(CXXFLAGS) $(TARGET_OS) $(bin_linkflags) $^ -o $@ $(liblist)
endef
else
define link_bin
$(CC) $(CFLAGS) $(TARGET_OS) $(bin_linkflags) $^ -o $@ $(liblist)
endef
endif
endif

# modify flags for compiling binary executables
ifeq (bin,$(MAKECMDGOALS))
CPPFLAGS += -DMDX_BIN
endif

# see if we need to link demos using C++ compiler
ifeq (yes,$(LINKCPP))
DEMOLINKCPP := yes
endif
ifneq (yes,$(DEMOLINKCPP))
demosrclist := $(wildcard $(addprefix $(srcdir)/$(SRC)/,$(addsuffix .*,$(basename $(DEMO) $(DEMOOBJ)))))
# set DEMOLINKCPP to "yes" if any current source files have suffix .cc .C .cxx
DEMOLINKCPP := $(sort $(foreach s,.cc .C .cxx,$(if $(findstring $(s),$(suffix $(demosrclist))),yes)))
endif

# define demo executable link command
ifndef link_demo
ifeq (yes,$(DEMOLINKCPP))
define link_demo
$(CXX) $(CXXFLAGS) $(TARGET_OS) $(bin_linkflags) $^ -o $@ $(demoliblist)
endef
else
define link_demo
$(CC) $(CFLAGS) $(TARGET_OS) $(bin_linkflags) $^ -o $@ $(demoliblist)
endef
endif
endif

# this target called from main makefile
# below we recursively call this makefile from the object build directory
$(SRC) : $(buildirlist)
ifneq (,$(typelist))
	@for t in $(typelist); do \
	  $(MAKE) -C $(objdirprefix)$$t/$@ -f $(CURDIR)/src.mk $$t \
	    MAKEFILES="$(cfgsave) $(buildfile) $(srcdir)/$@/GNUmakefile" \
	    SRC="$@" INSTALL_LIB="$(INSTALL_LIB)"; \
	done
endif
ifneq (,$(demolist))
	@for d in $(demolist); do \
	  $(MAKE) -C $(objdirprefix)demo/$@ -f $(CURDIR)/src.mk $(demodir)/$$d \
	    MAKEFILES="$(cfgsave) $(buildfile) $(srcdir)/$@/GNUmakefile" \
	    SRC="$@" INSTALL_LIB="$(INSTALL_LIB)" demoname="$$d"; \
	done
endif

# directories that don't exist get created
$(buildirlist) :
	mkdir $@

bin : $(bindir)/$(bin_name)

$(bindir)/$(bin_name) : $(objlist)
	$(link_bin)

dynamic : $(libdir)/$(dlib_name)

$(libdir)/$(dlib_name) : $(objlist)
	$(link_dynamic)

static : $(libdir)/$(slib_name)

$(libdir)/$(slib_name) : $(objlist)
	$(link_static)

plugin : $(libdir)/$(plug_name)

$(libdir)/$(plug_name) : $(objlist)
	$(link_plugin)

ifneq (,$(strip $(demoname)))
$(demodir)/$(demoname) : $(demoname).o $(demoobjlist)
	$(link_demo)
endif

# automate header file dependency checking
#
# generate in obj_ directory a .d file for every source file
#   containing header dependencies using "cc -M" or equivalent
# use sed to modify the compiler generated dependency files
#   so that the .d targets share same dependencies as .o files
#
# See online GNU make manual for details
#   http://www.gnu.org/software/make/manual/make.html (chap 4.14)
ifneq ($(MAKECMDGOALS),$(SRC))
%.d : %.c
	@set -e; rm -f $@; \
	  $(CC) $(CFLAGS) $(DEPFLAGS) $(CPPFLAGS) $< > $@.$$$$; \
	  sed 's,\($*\)\.o[ :]*,\1.o $@ : ,g' < $@.$$$$ > $@; \
	  rm -f $@.$$$$

%.d : %.cc
	@set -e; rm -f $@; \
	  $(CXX) $(CXXFLAGS) $(DEPFLAGS) $(CPPFLAGS) $< > $@.$$$$; \
	  sed 's,\($*\)\.o[ :]*,\1.o $@ : ,g' < $@.$$$$ > $@; \
	  rm -f $@.$$$$

%.d : %.C
	@set -e; rm -f $@; \
	  $(CXX) $(CXXFLAGS) $(DEPFLAGS) $(CPPFLAGS) $< > $@.$$$$; \
	  sed 's,\($*\)\.o[ :]*,\1.o $@ : ,g' < $@.$$$$ > $@; \
	  rm -f $@.$$$$

# include the correct set of .d files
ifneq (,$(strip $(demoname)))
-include $(patsubst %.o,%.d,$(demoname).o $(demoobjlist))
else
ifneq (,$(strip $(objlist)))
-include $(patsubst %.o,%.d,$(objlist))
endif
endif

endif
