#
# Copyright (C) 2003-2005 by David J. Hardy.  All rights reserved.
#
# architecture dependent file for building on Linux
# (flags set for GNU compilers)
 
# used in gnu make implicit rules
CC := gcc
CXX := g++
CPPFLAGS := -DMDX_LINUX -D_GNU_SOURCE -I$(srcdir) -I- -Wall -pedantic
CFLAGS := -O -std=c99
CXXFLAGS := -O -std=c++98
TARGET_ARCH :=
LDFLAGS :=
LOADLIBES :=
LDLIBS :=

# flags for computing dependencies
DEPFLAGS := -MM 

# definitions for linking static libraries
slib_name := lib$(NAME).a

# definitions for linking dynamic libraries
dlib_name := lib$(NAME).so
dlib_flags := -fPIC -shared
dlib_linkflags := -Wl,-h,$(dlib_name) -L$(libdir)
dlib_linkflags += -Wl,-rpath,$(INSTALL_LIB) -Wl,-rpath-link,$(libdir)

# definitions for linking plugins (dynamically loadable modules)
plug_name := $(NAME).so
plug_flags := -fPIC -shared
plug_linkflags := -Wl,-h,$(plug_name) -L$(libdir)
plug_linkflags += -Wl,-rpath,$(INSTALL_LIB) -Wl,-rpath-link,$(libdir)

# definitions for linking binary executables
bin_name := $(NAME)
bin_linkflags := -L$(libdir)
bin_linkflags += -Wl,-rpath,$(INSTALL_LIB) -Wl,-rpath-link,$(libdir)

# extra link options needed for optional libraries
ifneq (,$(strip $(filter-out $(libdir),$(optlib_dirlist))))
comma := ,
dlib_linkflags += $(addprefix -L,$(optlib_dirlist))
dlib_linkflags += $(addprefix -Wl$(comma)-rpath$(comma),$(optlib_dirlist))
plug_linkflags += $(addprefix -L,$(optlib_dirlist))
plug_linkflags += $(addprefix -Wl$(comma)-rpath$(comma),$(optlib_dirlist))
bin_linkflags += $(addprefix -L,$(optlib_dirlist))
bin_linkflags += $(addprefix -Wl$(comma)-rpath$(comma),$(optlib_dirlist))
endif
