/*
 * Author:	Kenneth Chin-Purcell, AHPCRC
 *		Copyright 1991, Minnesota Supercomputer Center, Inc.
 *
 * Purpose:	General utilities
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 *
 */

#include <malloc.h>
#include <string.h>
#include <stdio.h>

#ifdef ultrix
typedef	char	*VoidPtr;
#else
/*typedef	void	*VoidPtr;*/
#define VoidPtr void*
#endif

#define MIN(i,j)  ((i)<(j) ? (i) : (j))
#define MAX(i,j)  ((i)>(j) ? (i) : (j))
#define ABS(i)    ((i)> 0  ? (i) : -(i))

#define MATCH(sa,sb)	(strncmp(sa, sb, strlen(sb)) == 0)

#define MallocType(type)	(type *) malloc(sizeof(type))
#define CallocType(type,i)	(type *) calloc(i,sizeof(type))
#define ReallocType(ptr,type,i)	(type *) realloc(ptr,i*sizeof(type))
#define Free(ptr)		if (ptr) free(ptr)

#define ZeroType(ptr,type)	(void) memset(ptr, 0, sizeof(type))
#define CopyType(dst,src,type)	(void) memcpy(dst, src, sizeof(type))

#define Verify(expr,estr)	if (!(expr)) BailOut(estr,__FILE__,__LINE__)
#define MemCheck(ptr)	if (!(ptr)) BailOut("Out of memory",__FILE__,__LINE__)


/* Prototypes */

/* util.c */
void	Error (char *errstr);
void	BailOut (char *errstr, char *fname, int lineno);
long	FindFileSize (char *fname);
void	ReadCmap (short cmap [256 ][3 ], char *cmapName);
char	*NewString (char *old, int extra);
void	CommaLong (char *s, long i);
long	Factor (long a);
char	*ReadString (FILE *file);
long	ReadLong (FILE *file);
float	ReadFloat (FILE *file);
char	*ReadToken (FILE *file);
int	PositionAtString (char *s, FILE *file);
long	*MakeLongArray (long num);
float	*MakeFloatArray (long num);
void	ReadFloatArray (float *farr, long num, FILE *file);
void	ReadLongArray (long *larr, long num, FILE *file);
